/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.view.View;
import android.widget.TextView;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.permission.PermissionHelper;
import net.aihelp.utils.ResResolver;

public class RequestAlertHelper {
    private static final String AIHELP_PERMISSION_REQUEST_ALERT = "AIHELP_PERMISSION_REQUEST_ALERT";

    private static boolean checkMetaData(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                for (String key : appInfo.metaData.keySet()) {
                    if (!AIHELP_PERMISSION_REQUEST_ALERT.equals(key)) continue;
                    return "yes".equals(appInfo.metaData.get(key));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void request(Context context, PermissionHelper helper) {
        if (helper == null) {
            return;
        }
        if (context != null && RequestAlertHelper.checkMetaData(context)) {
            RequestAlertHelper.showRequestAlert(context, helper);
        } else {
            helper.requestPermission();
        }
    }

    public static void showRequestAlert(Context context, final PermissionHelper helper) {
        if (helper.avoidInvoking()) {
            return;
        }
        final AlertDialog requestPermissionDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_request_permission")).setWidthByDevice().create();
        TextView tvTitle = (TextView)requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        TextView tvCancel = (TextView)requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_cancel"));
        TextView tvConfirm = (TextView)requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_confirm"));
        tvTitle.setText((CharSequence)ResResolver.getString("aihelp_storage_permission"));
        tvCancel.setText((CharSequence)ResResolver.getString("aihelp_no"));
        tvConfirm.setText((CharSequence)ResResolver.getString("aihelp_yes"));
        requestPermissionDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener(){

            public void onClick(View v) {
                requestPermissionDialog.dismiss();
                helper.setInvokeId(-1);
                helper.invokePermissionCallback(Permission.Result.CANCELED);
            }
        });
        tvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                requestPermissionDialog.dismiss();
                helper.requestPermission();
            }
        });
        requestPermissionDialog.show();
    }
}

