/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.viewer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.core.ui.glide.DrawableRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.resource.drawable.GlideDrawable;
import net.aihelp.core.ui.glide.request.RequestListener;
import net.aihelp.core.ui.glide.request.target.Target;
import net.aihelp.core.util.viewer.IOnUserActionResultListener;
import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;

public class ViewerLayout
extends RelativeLayout {
    private View rootView;
    private String imagePath;
    private PhotoView imageView;
    private String videoPath;
    private VideoView videoView;
    private ProgressBar progressBar;
    private IOnUserActionResultListener listener;

    public ViewerLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ViewerLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ViewerLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.rootView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_dialog_media_viewer"), (ViewGroup)this);
        this.setGravity(17);
        this.setBackgroundColor(this.getBackgroundColorByAlpha(255.0f));
        AIHelpButton tvCancel = (AIHelpButton)this.rootView.findViewById(ResResolver.getViewId("aihelp_tv_cancel"));
        tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ViewerLayout.this.listener != null) {
                    ViewerLayout.this.listener.onCancel();
                }
            }
        });
        AIHelpButton tvConfirm = (AIHelpButton)this.rootView.findViewById(ResResolver.getViewId("aihelp_tv_confirm"));
        tvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ViewerLayout.this.listener != null) {
                    ViewerLayout.this.listener.onConfirm(ViewerLayout.this.imagePath);
                }
            }
        });
        this.imageView = (PhotoView)this.rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        this.videoView = (VideoView)this.rootView.findViewById(ResResolver.getViewId("aihelp_video_view"));
        this.videoView.setBackgroundColor(-16777216);
        this.progressBar = (ProgressBar)this.rootView.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                ViewerLayout.this.videoView.start();
                mp.setLooping(true);
                if (Build.VERSION.SDK_INT < 17) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ViewerLayout.this.finishVideoBuffer();
                        }
                    }, 1000L);
                }
            }
        });
        if (Build.VERSION.SDK_INT >= 17) {
            this.videoView.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                public boolean onInfo(MediaPlayer mp, int what, int extra) {
                    if (what == 3) {
                        ViewerLayout.this.finishVideoBuffer();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void finishVideoBuffer() {
        this.videoView.seekTo(0);
        this.progressBar.setVisibility(8);
        this.imageView.setVisibility(8);
        this.videoView.setBackgroundColor(0);
    }

    public void show() {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            if (!TextUtils.isEmpty((CharSequence)this.videoPath)) {
                this.imageView.enableGesture(false);
                this.videoView.setVisibility(0);
                this.videoView.setVideoPath(this.videoPath);
            } else {
                this.videoView.setVisibility(8);
            }
            ((DrawableRequestBuilder)Glide.with(this.getContext()).load(this.imagePath).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

                @Override
                public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                    if (TextUtils.isEmpty((CharSequence)ViewerLayout.this.videoPath)) {
                        ViewerLayout.this.progressBar.setVisibility(8);
                    }
                    return false;
                }

                @Override
                public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                    if (TextUtils.isEmpty((CharSequence)ViewerLayout.this.videoPath)) {
                        ViewerLayout.this.progressBar.setVisibility(8);
                    }
                    return false;
                }
            })).into((ImageView)this.imageView);
        }
    }

    int getBackgroundColorByAlpha(float alpha) {
        int bgColor = -16777216;
        return Color.argb((int)Math.round(alpha), (int)Color.red((int)bgColor), (int)Color.green((int)bgColor), (int)Color.blue((int)bgColor));
    }

    public void updateImageResource(String imagePath) {
        this.imagePath = DomainSupportHelper.getAdjustedUrl(imagePath);
    }

    public void updateVideoResource(String videoPath) {
        this.videoPath = DomainSupportHelper.getAdjustedUrl(videoPath);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void setOnChildViewClickedListener(View.OnClickListener onClickListener) {
        if (this.rootView != null) {
            this.rootView.setOnClickListener(onClickListener);
        }
        if (this.imageView != null) {
            this.imageView.setOnClickListener(onClickListener);
        }
    }

    public void setOnUserActionResultListener(IOnUserActionResultListener listener) {
        this.listener = listener;
    }
}

