/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.attachment;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import net.aihelp.config.AIHelpContext;
import net.aihelp.data.attachment.AttachmentHelper;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.ui.preview.data.PreviewInfo;

public enum AttachmentPicker {
    INSTANCE;

    public static final int ATTACHMENT_TYPE_MEDIA = 1;
    public static final int ATTACHMENT_TYPE_FILE = 2;
    public static final int ATTACHMENT_TYPE_RPA = 3;
    public static final int ATTACHMENT_FILE_NOT_FOUND = -1;
    public static final int ATTACHMENT_FILE_SIZE_LIMIT_EXCEEDED = -2;
    public static final int NO_APPS_TO_OPEN_ATTACHMENTS_INTENT = -3;
    public static final int INVALID_URI = -4;
    private static final long MAX_ATTACHMENT_FILE_SIZE_LIMIT = 0x1900000L;
    private WeakReference<Fragment> pickerHostRef;
    private WeakReference<IAttachmentPickerListener> attachmentPickerListenerRef;
    private int attachmentType;

    public <T extends Fragment> AttachmentPicker setPickerHost(T fragment) {
        this.pickerHostRef = new WeakReference<T>(fragment);
        return this;
    }

    public <T extends IAttachmentPickerListener> AttachmentPicker setAttachmentPickerListener(T listener) {
        if (listener != null) {
            this.attachmentPickerListenerRef = new WeakReference<T>(listener);
        }
        return this;
    }

    public void launchPicker(int attachmentType) {
        this.attachmentType = attachmentType;
        try {
            Fragment fragment;
            if (this.pickerHostRef != null && (fragment = (Fragment)this.pickerHostRef.get()) != null && fragment.getActivity() != null) {
                fragment.startActivityForResult(AttachmentHelper.getIntentForMedia(attachmentType), 1001);
            }
        }
        catch (ActivityNotFoundException ignored) {
            this.sendPickFailure(-3);
        }
    }

    public void onAttachmentRequestResult(int requestCode, int resultCode, Intent intent) {
        switch (requestCode) {
            case 1001: {
                if (resultCode != -1 || intent == null) break;
                this.onConfirmResult(intent.getData());
                break;
            }
            case 1002: {
                this.onPreviewResult(resultCode, intent);
                break;
            }
        }
    }

    private void onConfirmResult(Uri uri) {
        if (uri != null) {
            File copiedUriFile = AttachmentHelper.getCopiedUriFile(AIHelpContext.getInstance().getContext(), uri);
            if (copiedUriFile != null) {
                this.sendPickSuccess(copiedUriFile);
            } else {
                this.sendPickFailure(-1);
            }
        } else {
            this.sendPickFailure(-4);
        }
    }

    private void onPreviewResult(int resultCode, Intent intent) {
        IAttachmentPickerListener attachmentPickerListener;
        if (this.attachmentPickerListenerRef != null && (attachmentPickerListener = (IAttachmentPickerListener)this.attachmentPickerListenerRef.get()) != null) {
            if (resultCode == -1 && intent != null) {
                PreviewInfo info;
                String filePath;
                Serializable serializable = intent.getSerializableExtra("preview_info");
                if (serializable instanceof PreviewInfo && !TextUtils.isEmpty((CharSequence)(filePath = (info = (PreviewInfo)serializable).getFilePath()))) {
                    attachmentPickerListener.onPreviewConfirmed(filePath);
                }
            } else {
                attachmentPickerListener.onPreviewCanceled(this.attachmentType);
            }
        }
    }

    private void sendPickSuccess(File pickedFile) {
        IAttachmentPickerListener attachmentPickerListener;
        if (this.attachmentPickerListenerRef != null && (attachmentPickerListener = (IAttachmentPickerListener)this.attachmentPickerListenerRef.get()) != null) {
            attachmentPickerListener.onPickSuccess(pickedFile);
        }
    }

    private void sendPickFailure(int errorCode) {
        IAttachmentPickerListener attachmentPickerListener;
        if (this.attachmentPickerListenerRef != null && (attachmentPickerListener = (IAttachmentPickerListener)this.attachmentPickerListenerRef.get()) != null) {
            attachmentPickerListener.onPickFailure(errorCode);
        }
    }
}

