/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class ElvaRepository
extends AbsRepository {
    public ElvaRepository(Context context) {
        super(context);
    }

    public List<FaqListEntity> getMatchedFaqListForAlert(String query) {
        ArrayList<FaqListEntity> matchedList = new ArrayList<FaqListEntity>();
        HashMap<String, Integer> faqKeywordsMatching = new HashMap<String, Integer>();
        HashMap<String, String> faqTitleMapping = new HashMap<String, String>();
        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();
        block0: for (int i = 0; i < sourceFaqs.length(); ++i) {
            JSONObject faq = JsonHelper.getJsonObject(sourceFaqs, i);
            String string = faq.optString("keyWords");
            String faqMainId = faq.optString("kmMainid");
            String faqTitle = faq.optString("question");
            String similarQuestions = faq.optString("similarQuestions");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                String[] keywordsArr;
                for (String keyword : keywordsArr = string.split(",")) {
                    if (!query.toLowerCase().contains(keyword)) continue;
                    if (faqKeywordsMatching.size() >= 3) break block0;
                    Integer matchedCounts = (Integer)faqKeywordsMatching.get(faqMainId);
                    faqKeywordsMatching.put(faqMainId, matchedCounts == null ? 1 : matchedCounts + 1);
                    faqTitleMapping.put(faqMainId, faqTitle);
                }
                if (faqKeywordsMatching.get(faqMainId) != null) continue;
            }
            if (faqTitle.toLowerCase().contains(query.toLowerCase())) {
                faqKeywordsMatching.put(faqMainId, 0);
                faqTitleMapping.put(faqMainId, faqTitle);
                if (faqKeywordsMatching.size() >= 3) break;
            }
            if (!similarQuestions.toLowerCase().contains(query.toLowerCase())) continue;
            faqKeywordsMatching.put(faqMainId, -1);
            faqTitleMapping.put(faqMainId, faqTitle);
            if (faqKeywordsMatching.size() >= 3) break;
        }
        ArrayList list = new ArrayList(faqKeywordsMatching.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : list) {
            String mainId = (String)entry.getKey();
            FaqListEntity matched = new FaqListEntity(0, mainId, (String)faqTitleMapping.get(mainId), query);
            matchedList.add(matched);
        }
        return matchedList;
    }
}

