/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize;

import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.config.BusinessLogicHelper;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.localize.config.StyleSheetHelper;
import net.aihelp.data.localize.config.TextHelper;
import net.aihelp.data.localize.config.UploadLimitHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.localize.data.LocaleStringHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.track.ResourceLoadTracker;
import net.aihelp.init.InitHelper;
import net.aihelp.utils.FileUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LocalizeHelper {
    public static final int FLAG_FAQ_SECTION = 1001;
    public static final int FLAG_LOCALE = 1005;
    public static final int FLAG_STYLE_SHEET = 1006;
    public static final int FLAG_BUSINESS_LOGIC = 1007;
    public static final int FLAG_FAQ_HOT_TOPIC = 1009;
    public static final int FLAG_PROCESS = 1010;
    public static final int FLAG_TEXT = 1011;
    public static final int FLAG_UPLOAD_LIMIT = 1012;

    public static void resetLocalizeData() {
        FaqHelper.INSTANCE.reset();
        LocaleStringHelper.INSTANCE.reset();
        TextHelper.INSTANCE.reset();
        ProcessEntranceHelper.INSTANCE.reset();
        UploadLimitHelper.INSTANCE.reset();
    }

    public static List<Integer> getLocalizeResourceList(List<Integer> resourceList) {
        int[] modeList;
        for (int mode : modeList = new int[]{1005, 1006, 1007, 1009, 1011, 1012, 1010}) {
            if (LocalizeUtil.isAlreadyLocalized(mode)) {
                LocalizeHelper.prepareDataSourceByMode(mode);
                continue;
            }
            resourceList.add(mode);
        }
        return resourceList;
    }

    public static void goFetchLocalizeData() {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                ArrayList<Integer> resourceList = new ArrayList<Integer>();
                if (LocalizeUtil.isAlreadyLocalized(1001)) {
                    FaqHelper.INSTANCE.prepareDataSource();
                } else if (Const.TOGGLE_LOCALIZE_VIA_INIT) {
                    resourceList.add(1001);
                }
                List<Integer> localizeList = LocalizeHelper.getLocalizeResourceList(resourceList);
                ResourceLoadTracker.getInstance().onResourceRequested(localizeList.size());
                for (int i = 0; i < localizeList.size(); ++i) {
                    LocalizeHelper.getLocalizeDataFromUrl(localizeList.get(i));
                }
            }
        });
    }

    public static void getLocalizeDataFromUrl(final int mode) {
        if (mode == 1001 && FaqHelper.isFaqDataAlreadyPrepared()) {
            return;
        }
        AIHelpRequest.getInstance().requestDownloadFile(mode, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String result) {
                ResourceLoadTracker.getInstance().onResourceRetrieved(mode, true);
                LocalizeHelper.prepareDataSourceByMode(mode);
            }

            @Override
            public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                ResourceLoadTracker.getInstance().onResourceRetrieved(mode, false);
                switch (mode) {
                    case 1001: {
                        LocalizeHelper.getDataAfterLocalizeFailed();
                        break;
                    }
                    case 1010: {
                        if (TextUtils.isEmpty((CharSequence)url)) {
                            errorMsg = "Failed downloading custom entrance configuration, please checkout your configuration in AIHelp Dashboard and re-publish.";
                        }
                        InitHelper.getInstance().onAIHelpInitializedCallback(false, errorMsg);
                        break;
                    }
                }
            }
        });
    }

    private static void prepareDataSourceByMode(int mode) {
        switch (mode) {
            case 1001: {
                FaqHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1005: {
                LocaleStringHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1006: {
                StyleSheetHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1007: {
                BusinessLogicHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1009: {
                FaqHelper.INSTANCE.prepareNotificationAndHotTopics();
                break;
            }
            case 1010: {
                ProcessEntranceHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1011: {
                TextHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 1012: {
                UploadLimitHelper.INSTANCE.prepareDataSource();
            }
        }
    }

    private static void getDataAfterLocalizeFailed() {
        AIHelpRequest.getInstance().requestGetByAsync(API.FAQ_URL, null, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String str) {
                try {
                    boolean success;
                    if (!TextUtils.isEmpty((CharSequence)str) && (success = FileUtil.writeFileToDisk(new ByteArrayInputStream(str.getBytes()), LocalizeUtil.getFileLocation(1001)))) {
                        FaqHelper.INSTANCE.prepareDataSource();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

