/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.IntentEntity;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.init.InitHelper;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONObject;

public enum ProcessEntranceHelper {
    INSTANCE;

    private final Map<String, ProcessEntity> processMap = new ConcurrentHashMap<String, ProcessEntity>();
    private ProcessEntity currentProcess;

    public void reset() {
        this.processMap.clear();
        this.currentProcess = null;
    }

    public void prepareDataSource() {
        String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1010));
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONArray jsonArray = JsonHelper.getJsonArray(content);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                String processId = JsonHelper.optString(jsonObject, "processId");
                ProcessEntity processEntity = new ProcessEntity();
                processEntity.setEntranceId(processId);
                processEntity.setIntent(jsonObject.optInt("homeSettings"));
                processEntity.setFaqId(JsonHelper.optString(jsonObject, "faqId"));
                processEntity.setSectionId(JsonHelper.optString(jsonObject, "faqId"));
                processEntity.setVisitId(JsonHelper.optString(jsonObject, "id"));
                processEntity.setTags(JsonHelper.getJsonArray(jsonObject, "tags"));
                processEntity.setFaqEntrances(JsonHelper.getJsonArray(jsonObject, "location"));
                JSONObject intentsMenu = JsonHelper.getJsonObject(jsonObject, "intentsMenu");
                processEntity.setEnableInteraction(intentsMenu.optBoolean("alwaysShow"));
                processEntity.setSmartIntentName(JsonHelper.optString(intentsMenu, "menuText"));
                processEntity.setSmartIntentList(this.getBindingIntent(intentsMenu));
                this.processMap.put(processId, processEntity);
            }
            InitHelper.getInstance().onAIHelpInitializedCallback(true, "");
        }
    }

    public ProcessEntity getCurrentProcess() {
        if (this.currentProcess == null) {
            return new ProcessEntity();
        }
        return this.currentProcess;
    }

    private List<IntentEntity> getBindingIntent(JSONObject jsonObject) {
        ArrayList<IntentEntity> intentList = new ArrayList<IntentEntity>();
        JSONArray intentsList = JsonHelper.getJsonArray(jsonObject, "intentsList");
        if (intentsList.length() > 0) {
            for (int i = 0; i < intentsList.length(); ++i) {
                JSONObject intentObject = JsonHelper.getJsonObject(intentsList, i);
                IntentEntity intentEntity = new IntentEntity();
                intentEntity.setIntentId(intentObject.optInt("intentsId"));
                intentEntity.setIntentName(JsonHelper.optString(intentObject, "name"));
                intentEntity.setIntentList(this.getBindingIntent(intentObject));
                intentList.add(intentEntity);
            }
        }
        return intentList;
    }

    public ProcessEntity getProcess(String id2) {
        ProcessEntity processEntity = this.processMap.get(id2);
        if (processEntity == null) {
            processEntity = new ProcessEntity();
            processEntity.setEntranceId(id2);
            if ("test001".equals(id2)) {
                processEntity.setIntent(1);
            } else if ("test002".equals(id2)) {
                processEntity.setIntent(2);
            } else if ("test003".equals(id2)) {
                processEntity.setIntent(3);
            } else if ("test004".equals(id2)) {
                processEntity.setIntent(4);
            } else {
                TLog.d("No related process was found, please check your process id.");
            }
        }
        processEntity.setTrackActiveId(UUID.randomUUID().toString());
        UserProfile.ENTRANCE_TAGS = processEntity.getTags();
        this.currentProcess = processEntity;
        this.handleTrackLogic(processEntity);
        return processEntity;
    }

    private void handleTrackLogic(ProcessEntity processEntity) {
        if (processEntity != null) {
            AIHelpEventTracker tracker = AIHelpEventTracker.getInstance();
            tracker.setupTrackHandler(processEntity.getEntranceId(), processEntity.getTrackActiveId());
            switch (processEntity.getIntent()) {
                case 1: 
                case 2: 
                case 3: {
                    tracker.showAIHelp();
                    tracker.showHelpCenter();
                    break;
                }
                case 4: {
                    tracker.showAIHelp();
                    tracker.showCustomerService(true);
                }
            }
        }
    }
}

