/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.utils.FileUtil;
import org.json.JSONObject;

public enum UploadLimitHelper {
    INSTANCE;


    public void reset() {
        CustomConfig.UploadLimit.isImageEnableUploading = false;
        CustomConfig.UploadLimit.isVideoEnableUploading = false;
        CustomConfig.UploadLimit.isFileEnableUploading = false;
        CustomConfig.UploadLimit.imageTypes = "";
        CustomConfig.UploadLimit.videoTypes = "";
        CustomConfig.UploadLimit.fileTypes = "";
    }

    public void prepareDataSource() {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1012));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONObject object = new JSONObject(content);
                String imageTypes = object.optString("imageTypes");
                String videoTypes = object.optString("videoTypes");
                String fileTypes = object.optString("fileTypes");
                CustomConfig.UploadLimit.imageTypes = imageTypes.replace("\\.", "");
                CustomConfig.UploadLimit.isImageEnableUploading = this.isToggleOpen(object, "imageStatus");
                CustomConfig.UploadLimit.videoTypes = videoTypes.replace("\\.", "");
                CustomConfig.UploadLimit.isVideoEnableUploading = this.isToggleOpen(object, "videoStatus");
                CustomConfig.UploadLimit.fileTypes = String.format("%s,%s,%s", imageTypes, videoTypes, fileTypes);
                CustomConfig.UploadLimit.isFileEnableUploading = this.isToggleOpen(object, "fileStatus");
                CustomConfig.UploadLimit.imageMaxSize = object.optInt("imageMaxSize", CustomConfig.UploadLimit.imageMaxSize);
                CustomConfig.UploadLimit.videoMaxSize = object.optInt("videoMaxSize", CustomConfig.UploadLimit.videoMaxSize);
                CustomConfig.UploadLimit.fileMaxSize = object.optInt("fileMaxSize", CustomConfig.UploadLimit.fileMaxSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isToggleOpen(JSONObject jsonObject, String key) {
        return jsonObject != null && jsonObject.optInt(key) == 1;
    }
}

