/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.local.FaqRepository;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public class FaqPresenter
extends AbsPresenter<BaseFaqFragment, FaqRepository> {
    private static final ApiExecutor sApiExecutor = ApiExecutorFactory.getHandlerExecutor();

    public FaqPresenter(Context context) {
        super(context);
    }

    private void fetchFaqDataSourceOnDemand(final String sectionOrFaqId) {
        if (this.isNetworkAvailable()) {
            ((BaseFaqFragment)this.mView).showLoading();
            String faqUrl = LocalizeUtil.getUrl(1001);
            if (Pattern.compile(".+\\.(json)$").matcher(faqUrl).matches()) {
                AIHelpRequest.getInstance().requestDownloadFile(1001, new ReqCallback<String>(){

                    @Override
                    public void onAsyncReqSuccess(String result) {
                        FaqHelper.INSTANCE.prepareDataSource(new Runnable(){

                            @Override
                            public void run() {
                                FaqPresenter.this.refreshFaqs(sectionOrFaqId);
                            }
                        });
                    }

                    @Override
                    public void onFailure(String url, int errorCode, String errorMsg) {
                        FaqPresenter.this.getFaqFromApiAfterLocalizeFailed(sectionOrFaqId);
                    }
                });
            }
        } else {
            ((BaseFaqFragment)this.mView).showNetError();
        }
    }

    private void getFaqFromApiAfterLocalizeFailed(final String sectionOrFaqId) {
        this.get(API.FAQ_URL, null, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String str) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)str)) {
                        boolean success = FileUtil.writeFileToDisk(new ByteArrayInputStream(str.getBytes()), LocalizeUtil.getFileLocation(1001));
                        if (success) {
                            FaqHelper.INSTANCE.prepareDataSource(new Runnable(){

                                @Override
                                public void run() {
                                    FaqPresenter.this.refreshFaqs(sectionOrFaqId);
                                }
                            });
                        } else {
                            ((BaseFaqFragment)FaqPresenter.this.mView).showEmpty(new int[0]);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void refreshFaqs(String sectionOrFaqId) {
        if (this.mView != null && !((BaseFaqFragment)this.mView).isDetached()) {
            ((BaseFaqFragment)this.mView).restoreViewState();
            if (this.mView instanceof FaqHomeFragment || this.mView instanceof FaqListFragment) {
                this.goFetchFAQDataSource(sectionOrFaqId);
            }
            if (this.mView instanceof FaqContentFragment) {
                this.goFetchQuestionContent(null, sectionOrFaqId, "");
            }
        }
    }

    public void goFetchFAQDataSource(String sectionId) {
        if (FaqHelper.isFaqDataAlreadyPrepared()) {
            boolean rootPage = TextUtils.isEmpty((CharSequence)sectionId);
            List<FaqListEntity> dataSource = rootPage ? FaqHelper.INSTANCE.getRootSections() : (((FaqRepository)this.mRepo).checkWhetherHasSubSection(sectionId) ? FaqHelper.INSTANCE.getSubSections(sectionId) : FaqHelper.INSTANCE.getQuestionList(sectionId));
            if (this.mView != null && !((BaseFaqFragment)this.mView).isDetached()) {
                ((BaseFaqFragment)this.mView).refreshList(dataSource, sectionId);
            }
        } else {
            this.fetchFaqDataSourceOnDemand(sectionId);
        }
    }

    public void goFetchQuestionContent(String sectionId, String faqId, String searchTerm) {
        if (FaqHelper.isFaqDataAlreadyPrepared()) {
            FaqContentEntity faq = FaqHelper.INSTANCE.getFaqById(sectionId, faqId);
            if (faq != null) {
                FaqContentEntity highlightedFaq = Styles.getFAQWithHighlightedSearchTerms(this.mContext, faq, searchTerm);
                if (this.mView == null || ((BaseFaqFragment)this.mView).isDetached()) {
                    return;
                }
                ((BaseFaqFragment)this.mView).refreshQuestionContent(highlightedFaq != null ? highlightedFaq : faq);
            } else {
                ((BaseFaqFragment)this.mView).showEmpty(new int[0]);
            }
        } else {
            this.fetchFaqDataSourceOnDemand(faqId);
        }
    }

    public void goQueryFAQList(final String query) {
        sApiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                final ArrayList<FaqListEntity> matchedFaqList = TextUtils.isEmpty((CharSequence)query) || FaqHelper.INSTANCE.getRawFlatFaqArray().length() == 0 ? null : ((FaqRepository)FaqPresenter.this.mRepo).getMatchedFaqList(query);
                sApiExecutor.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (FaqPresenter.this.mView != null && !((BaseFaqFragment)FaqPresenter.this.mView).isDetached()) {
                            ((BaseFaqFragment)FaqPresenter.this.mView).refreshList(matchedFaqList);
                        }
                    }
                });
            }
        });
    }

    public void prepareFAQNotification() {
        if (Const.TOGGLE_OPEN_FAQ_NOTIFICATION) {
            IMqttCallback mqttCallback = MqttCallbackImpl.getInstance();
            mqttCallback.updateHostView((Fragment)this.mView);
            AIHelpMqtt.getInstance().prepare(3, mqttCallback);
        }
        try {
            JSONObject params = new JSONObject();
            params.put("appid", (Object)Const.APP_ID);
            params.put("uid", (Object)UserProfile.USER_ID);
            this.get(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            JSONObject jsonObject = new JSONObject(result);
                            int newCount = jsonObject.optInt("cs_message_count");
                            boolean isTicketActive = jsonObject.optBoolean("isHaveChat");
                            int cachedCount = FaqPresenter.this.mSp.getInt(UserProfile.USER_ID, 0);
                            if (Math.max(0, newCount - cachedCount) > 0) {
                                ((BaseFaqFragment)FaqPresenter.this.mView).showEntranceWithNotification(true, false);
                            } else if (isTicketActive) {
                                ((BaseFaqFragment)FaqPresenter.this.mView).showEntranceWithNotification(false, false);
                            }
                        }
                    }
                    catch (Exception e) {
                        TLog.d("FAQ fetch new msg failed, because " + e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasSubSection(String sectionId) {
        return ((FaqRepository)this.mRepo).checkWhetherHasSubSection(sectionId);
    }

    public boolean shouldShowQuestionFooter(String faqId, long lastUpdateTime) {
        return ((FaqRepository)this.mRepo).shouldShowQuestionFooter(faqId, lastUpdateTime);
    }
}

