/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.data.local.InitRepository;
import net.aihelp.data.logic.UnreadMessagePoller;
import net.aihelp.init.InitHelper;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.LocaleUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class InitPresenter
extends AbsPresenter<IView, InitRepository> {
    private UnreadMessagePoller unreadMsgPoller;

    public InitPresenter(Context context, String appKey, String domain, String appId, String language) {
        super(context);
        ((InitRepository)this.mRepo).saveInitConfig(appKey, domain, appId, language);
    }

    public void updateUserProfile(final UserConfig config) {
        String cachedCrmInfo;
        String latelyCrmInfo;
        if (config == null) {
            return;
        }
        ((InitRepository)this.mRepo).saveUserProfileConfig(config);
        Const.TOGGLE_FETCH_MESSAGE = true;
        TicketStatusTracker.resetTicketStatusFlags();
        if (config.isSyncCrmInfo() && !(latelyCrmInfo = String.format("%s|%s", config.getUserId(), config.getUserTags())).equals(cachedCrmInfo = this.mSp.getString("crmInfo_" + config.getUserId()))) {
            try {
                JSONObject json = new JSONObject();
                json.put("userName", (Object)config.getUserName());
                json.put("uId", (Object)config.getUserId());
                json.put("tags", (Object)config.getUserTags());
                this.post(API.SYNC_VIP_INFO, json, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        ((InitRepository)InitPresenter.this.mRepo).saveCrmInfo(config.getUserId(), config.getUserTags());
                    }
                });
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.postCrmPushTokenInfo();
    }

    public void postCrmPushTokenInfo() {
        String pushToken = UserProfile.PUSH_TOKEN;
        int pushPlatform = UserProfile.PUSH_PLATFORM;
        if (!TextUtils.isEmpty((CharSequence)pushToken) && pushPlatform > 0) {
            String cachedCrmPushInfo;
            String latelyCrmPushInfo;
            ((InitRepository)this.mRepo).saveMqttPushInfo(pushToken, pushPlatform);
            if (Const.TOGGLE_CRM_TOKEN && !(latelyCrmPushInfo = String.format("%s|%s|%s", UserProfile.USER_ID, pushToken, pushPlatform)).equals(cachedCrmPushInfo = this.mSp.getString("sp_crm_push_info"))) {
                try {
                    JSONObject params = new JSONObject();
                    params.put("token", (Object)pushToken);
                    params.put("pushTypeId", pushPlatform);
                    params.put("playerId", (Object)UserProfile.USER_ID);
                    params.put("playerName", (Object)UserProfile.USER_NAME);
                    params.put("language", (Object)Const.CORRECT_LANGUAGE);
                    params.put("deviceId", (Object)DeviceUuidFactory.id(this.mContext));
                    this.post(API.CRM_TOKEN_URL, params, new ReqCallback<String>(){

                        @Override
                        public void onReqSuccess(String result) {
                            InitPresenter.this.mSp.put("sp_crm_push_info", latelyCrmPushInfo);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateSDKLanguage(String sdkLanguage) {
        String formatLanguage = LocaleUtil.getFormatLanguage(sdkLanguage);
        if (!Const.ORIGINAL_LANGUAGE.equals(formatLanguage)) {
            AIHelpContext.successfullyInit.set(false);
            Const.CORRECT_LANGUAGE = Const.ORIGINAL_LANGUAGE = formatLanguage;
            InitHelper.getInstance().requestInit(false);
        } else {
            Log.e((String)"TAG", (String)("AIHelp is using " + formatLanguage + " as global language already!"));
        }
    }

    public void setUploadLogPath(String logPath) {
        ((InitRepository)this.mRepo).setUploadLogPath(logPath);
    }

    public void setNetworkCheckHostAddress(String hostAddress, OnNetworkCheckResultCallback listener) {
        hostAddress = TextUtils.isEmpty((CharSequence)hostAddress) ? "aihelp.net" : hostAddress.replace("http://", "").replace("https://", "");
        ((InitRepository)this.mRepo).setNetworkCheckHostAddress(hostAddress);
        Const.sCheckResultListener = listener;
    }

    public void startUnreadMessagePolling(OnMessageCountArrivedCallback listener) {
        if (listener != null && this.unreadMsgPoller == null) {
            Const.sMessageListener = listener;
            this.unreadMsgPoller = new UnreadMessagePoller();
            this.unreadMsgPoller.start();
        }
    }

    public void stopUnreadMessagePolling() {
        if (Const.sMessageListener != null && this.unreadMsgPoller != null) {
            this.unreadMsgPoller.stop();
            Const.sMessageListener = null;
        }
    }
}

