/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.aihelp.common.API;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.cs.util.rpa.helper.ResponseHelper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.SpUtil;
import org.json.JSONObject;

public enum MessagePoller {
    INSTANCE;

    public static final int POLL_SOURCE_LOGIN = 1;
    public static final int POLL_SOURCE_FAILURE = 2;
    public static final int POLL_SOURCE_RECONNECT = 3;
    public static final int POLL_SOURCE_SCHEDULER = 4;
    private ScheduledFuture<?> newMessageFetcher;
    private WeakReference<CustomerServiceFragment> csFragment;

    public void startMessagePolling(Fragment fragment) {
        if (fragment instanceof CustomerServiceFragment) {
            this.csFragment = new WeakReference<CustomerServiceFragment>((CustomerServiceFragment)fragment);
        }
        if (SpUtil.getInstance().getBoolean("sp_log_toggle")) {
            TicketStatusTracker.ticketPollInterval = 10;
        }
        if (this.newMessageFetcher == null) {
            this.newMessageFetcher = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (MqttConfig.getInstance().isConnected()) {
                        return;
                    }
                    MessagePoller.this.fetchMessagesSinceLatest(4);
                }
            }, TicketStatusTracker.ticketPollInterval, TicketStatusTracker.ticketPollInterval, TimeUnit.SECONDS);
        }
    }

    public void stopMessagePolling() {
        if (this.newMessageFetcher != null) {
            this.newMessageFetcher.cancel(true);
            this.newMessageFetcher = null;
        }
    }

    public void fetchMessagesSinceLatest(int pollSource) {
        try {
            if (this.csFragment != null && this.csFragment.get() != null) {
                final CustomerServiceFragment customerServiceFragment = (CustomerServiceFragment)this.csFragment.get();
                JSONObject params = new JSONObject();
                params.put("messageTime", customerServiceFragment.getLastAgentMessageTimestamp());
                params.put("pollSource", pollSource);
                AIHelpRequest.getInstance().requestGetByAsync(API.POLL_MESSAGE_AFTER_MQTT_DISCONNECT, params, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        List<Message> pollResponse = ResponseHelper.getPollResponse(result);
                        Message message = ResponseHelper.getRPAMessage(result);
                        RPAStep lastRpaStep = ResponseHelper.getRPAStep(result);
                        if (TicketStatusTracker.isTicketFinished) {
                            lastRpaStep = new RPAStep();
                            if (TicketStatusTracker.isTicketWaitForAskingResolveStatus || TicketStatusTracker.isTicketWaitForRating) {
                                lastRpaStep.setNextStep(101);
                            } else {
                                lastRpaStep.setNextStep(102);
                            }
                        } else if (TicketStatusTracker.isTicketActive && TicketStatusTracker.isTicketServingByAgent()) {
                            lastRpaStep.setNextStep(100);
                        } else if (TicketStatusTracker.isTicketRejected) {
                            lastRpaStep.setNextStep(102);
                        }
                        if (!ListUtil.isListEmpty(pollResponse)) {
                            customerServiceFragment.updateChatList(pollResponse, false);
                        }
                        if (!TicketStatusTracker.isTicketServingByAnswerBot()) {
                            customerServiceFragment.updateBottomLayout(message, lastRpaStep, false);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

