/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.logic.MessagePoller;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.cs.util.rpa.helper.ResponseHelper;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.utils.UploadFileHelper;
import org.json.JSONObject;

public class MqttCallbackImpl
implements IMqttCallback {
    public static final int NOTIFICATION_TYPE_ASSIGN_CHANGE = 1;
    private WeakReference<BaseFaqFragment> faqFragment;
    private WeakReference<CustomerServiceFragment> csFragment;

    @Override
    public void updateHostView(Fragment fragment) {
        if (fragment instanceof CustomerServiceFragment) {
            this.csFragment = new WeakReference<CustomerServiceFragment>((CustomerServiceFragment)fragment);
        } else if (fragment instanceof BaseFaqFragment) {
            this.faqFragment = new WeakReference<BaseFaqFragment>((BaseFaqFragment)fragment);
        }
    }

    @Override
    public void onMqttResponse(String topic, String response) {
        try {
            JSONObject responseObject = new JSONObject(response);
            boolean isCodeNot200 = responseObject.has("code") && responseObject.optInt("code") != 200;
            boolean hasErrorCode = responseObject.has("errorCode");
            if (isCodeNot200 || hasErrorCode) {
                return;
            }
            switch (topic) {
                case "pushWithdraw": {
                    if (this.csFragment == null || this.csFragment.get() == null) break;
                    JSONObject pushWithdraw = new JSONObject(response);
                    ((CustomerServiceFragment)this.csFragment.get()).notifyMessageWithdrawn(pushWithdraw.optLong("withdrawkey", 0L));
                    break;
                }
                case "pushChat": {
                    if (this.csFragment == null || this.csFragment.get() == null) break;
                    Message replyMsg = ResponseHelper.getRPAMessage(response);
                    RPAStep rpaStep = ResponseHelper.getRPAStep(response);
                    if (rpaStep.isEnableUpload()) {
                        UploadFileHelper.INSTANCE.tryUploadLog(true);
                    } else {
                        if (replyMsg.isNormalMessage()) {
                            ((CustomerServiceFragment)this.csFragment.get()).updateChatList(replyMsg);
                        }
                        if (rpaStep.getNextStep() != 104) {
                            ((CustomerServiceFragment)this.csFragment.get()).updateBottomLayout(replyMsg, rpaStep);
                        }
                    }
                    ResponseHelper.notifyMqttPush("");
                    break;
                }
                case "pushOverflagChat": {
                    TicketStatusTracker.isTicketFinished = true;
                    TicketStatusTracker.isTicketWaitForAskingResolveStatus = responseObject.optBoolean("isShowResolve");
                    TicketStatusTracker.isTicketWaitForRating = CustomConfig.CustomerService.isTicketRatingEnable;
                    TicketStatusTracker.isAppRatable = "yes".equals(responseObject.optString("storeReview"));
                    if (this.csFragment == null || this.csFragment.get() == null) break;
                    ((CustomerServiceFragment)this.csFragment.get()).onTicketFinishedOrRejected();
                    break;
                }
                case "ticketRejected": {
                    TicketStatusTracker.isTicketRejected = true;
                    if (this.csFragment == null || this.csFragment.get() == null) break;
                    ((CustomerServiceFragment)this.csFragment.get()).onTicketFinishedOrRejected();
                    break;
                }
                case "pushFormChat": {
                    if (this.csFragment != null && this.csFragment.get() != null) {
                        String formContent = responseObject.optString("msg");
                        ((CustomerServiceFragment)this.csFragment.get()).onFormSubmitted(formContent);
                    }
                    AIHelpEventTracker.getInstance().onFormSubmitted(responseObject.optString("formId"));
                    if (Const.sSpecificFormSubmittedListener == null || !responseObject.getBoolean("isSpecificForm")) break;
                    Const.sSpecificFormSubmittedListener.onFormSubmitted();
                    break;
                }
                case "pushSdkMessage": {
                    if (this.faqFragment == null || this.faqFragment.get() == null) break;
                    ((BaseFaqFragment)this.faqFragment.get()).showEntranceWithNotification(true, true);
                    break;
                }
                case "pushNotification": {
                    if (TicketStatusTracker.isTicketFinished || TicketStatusTracker.isTicketRejected) break;
                    this.preparePushNotifications(response);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void preparePushNotifications(String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            int notifyType = jsonObject.optInt("type");
            JSONObject notifyData = JsonHelper.getJsonObject(jsonObject, "data");
            if (notifyType == 1) {
                TicketStatusTracker.ticketAssignType = notifyData.optInt("assignType");
                if (this.csFragment != null && this.csFragment.get() != null) {
                    if (TicketStatusTracker.isTicketServingByAgent()) {
                        RPAStep rpaStep = new RPAStep();
                        rpaStep.setNextStep(100);
                        ((CustomerServiceFragment)this.csFragment.get()).updateBottomLayout(new Message(), rpaStep);
                    }
                    ((CustomerServiceFragment)this.csFragment.get()).onTicketAssignStatusChanged();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onMqttConnected() {
    }

    @Override
    public void onMqttDisconnected() {
        this.showMqttLoading();
        if (this.csFragment != null && this.csFragment.get() != null && ((CustomerServiceFragment)this.csFragment.get()).isVisible()) {
            ((CustomerServiceFragment)this.csFragment.get()).prepareMqtt(2);
        }
    }

    @Override
    public void onMqttFailure() {
        MessagePoller.INSTANCE.fetchMessagesSinceLatest(2);
    }

    @Override
    public void onMqttSubscribed(int connectType) {
        MessagePoller.INSTANCE.fetchMessagesSinceLatest(connectType == 1 ? 1 : 3);
    }

    @Override
    public void showMqttLoading() {
        EventBus.getDefault().post(new LoadingElvaEvent(1003));
    }

    @Override
    public void dismissMqttLoading() {
        EventBus.getDefault().post(new LoadingElvaEvent(1004));
    }

    private MqttCallbackImpl() {
    }

    public static IMqttCallback getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final MqttCallbackImpl INSTANCE = new MqttCallbackImpl();

        private LazyHolder() {
        }
    }
}

