/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import java.util.Random;
import net.aihelp.init.InitHelper;

public class RequestRetryHandler
extends Handler {
    private static final int MAXIMUM_BACKOFF = 32000;
    private final OnRetryRequestListener retryListener;
    private final int maxRetryCount;
    private int retryCount;

    public RequestRetryHandler(OnRetryRequestListener retryListener, int maxRetryCount) {
        this.retryListener = retryListener;
        this.maxRetryCount = Math.max(3, maxRetryCount);
    }

    public void handleRetryRequest(int code, String errorMsg) {
        if (code >= 500) {
            InitHelper.getInstance().onAIHelpInitializedCallback(false, errorMsg);
            return;
        }
        double currentDelay = Math.pow(2.0, this.retryCount++) * 1000.0 + (double)new Random().nextInt(1001);
        if (this.retryCount <= this.maxRetryCount) {
            this.sendEmptyMessageDelayed(0, (long)Math.min(currentDelay, 32000.0));
        } else {
            this.removeCallbacksAndMessages(null);
            if (this.retryListener != null) {
                this.retryListener.onRetryUpToMaxCount(code, errorMsg);
            }
        }
    }

    public void handleMessage(@NonNull Message msg) {
        if (this.retryListener != null) {
            this.retryListener.onRetryRequest();
        }
    }

    public static interface OnRetryRequestListener {
        public void onRetryRequest();

        public void onRetryUpToMaxCount(int var1, String var2);
    }
}

