/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public class UnreadMessagePoller
extends Handler {
    private static final int POLL_UNREAD_MESSAGE = 100;

    public void start() {
        this.stop();
        this.sendEmptyMessage(100);
    }

    public void stop() {
        this.removeCallbacksAndMessages(null);
    }

    public void handleMessage(@NonNull Message msg) {
        if (this.isPollingEnable()) {
            this.fetchUnreadMessageCount();
        }
        this.sendEmptyMessageDelayed(100, this.getPollingLimit());
    }

    private void fetchUnreadMessageCount() {
        if (this.interceptFetchRequest()) {
            return;
        }
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "appid", Const.APP_ID);
        JsonHelper.put(params, "uid", UserProfile.USER_ID);
        AIHelpRequest.getInstance().requestGetByAsync(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                JSONObject jsonObject = JsonHelper.getJsonObject(result);
                Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                int newCount = jsonObject.optInt("cs_message_count");
                int cachedCount = Math.max(0, SpUtil.getInstance().getInt(UserProfile.USER_ID));
                if (Const.sMessageListener != null) {
                    Const.sMessageListener.onMessageCountArrived(Math.max(0, newCount - cachedCount));
                }
            }
        });
    }

    private boolean interceptFetchRequest() {
        if (Const.IS_SDK_SHOWING) {
            TLog.d("AIHelp", "AIHelp session is visible to user, do not need fetch for unread messages.");
            return true;
        }
        if (!Const.TOGGLE_FETCH_MESSAGE) {
            TLog.d("AIHelp", String.format("Current user(%s) does not have any active tickets at present.", UserProfile.USER_ID));
            return true;
        }
        if (UserProfile.USER_ID.equals(DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()))) {
            TLog.d("AIHelp", "The userId you're using for unread message polling is AIHelp's generated deviceId, please verify if this is what you want.");
        }
        return false;
    }

    private long getPollingLimit() {
        if (SpUtil.getInstance().getBoolean("sp_log_toggle")) {
            return 10000L;
        }
        if (!this.isPollingEnable()) {
            return 300000L;
        }
        return (long)Const.LIMIT_CHECKING_UNREAD * 1000L;
    }

    private boolean isPollingEnable() {
        return Const.TOGGLE_OPEN_UNREAD_MSG && Const.LIMIT_CHECKING_UNREAD > 0;
    }
}

