/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.cs;

import android.text.TextUtils;
import net.aihelp.ui.helper.BitmapHelper;

public class ConversationMsg {
    public static final int TYPE_ADMIN_TEXT = 11;
    public static final int TYPE_USER_TEXT = 21;
    public static final int TYPE_USER_TEXT_BOT = 31;
    public static final int TYPE_TIMESTAMP = 41;
    public static final int TYPE_ADMIN_FAQ = 51;
    public static final int TYPE_USER_IMAGE = 61;
    public static final int TYPE_USER_VIDEO = 71;
    public static final int TYPE_ADMIN_IMAGE = 81;
    public static final int TYPE_ADMIN_VIDEO = 91;
    public static final int TYPE_ADMIN_RICHTEXT = 101;
    public static final int TYPE_ADMIN_TYPING = 111;
    public static final int STATUS_FAQ_NORMAL = 100;
    public static final int STATUS_FAQ_HELPFUL = 200;
    public static final int STATUS_FAQ_UNHELPFUL = 300;
    public static final int STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN = 400;
    public static final int STATUS_SENDING = 1001;
    public static final int STATUS_RETRY = 1002;
    public static final int STATUS_SUCCESS = 1003;
    public static final int STATUS_FAILURE = 1004;
    private String nickname;
    private int msgType;
    private int msgStatus;
    private long timeStamp;
    private String msgContent;
    private String videoThumbnail;
    private int[] imageSize;
    private boolean isMessageFromServer;
    private String faqTicketId;

    public ConversationMsg() {
        this.setTimeStamp(System.currentTimeMillis());
    }

    public ConversationMsg(int msgType, int msgStatus) {
        this();
        this.msgType = msgType;
        this.msgStatus = msgStatus;
    }

    public String getFaqTicketId() {
        return this.faqTicketId;
    }

    public void setFaqTicketId(String faqTicketId) {
        if (!TextUtils.isEmpty((CharSequence)faqTicketId)) {
            this.faqTicketId = faqTicketId;
        }
    }

    public String getNickname() {
        if (TextUtils.isEmpty((CharSequence)this.nickname)) {
            return "";
        }
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getVideoThumbnail() {
        return this.videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        this.setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public void setMessageFromServer(boolean messageFromServer) {
        this.isMessageFromServer = messageFromServer;
    }

    public boolean isMessageFromServer() {
        return this.isMessageFromServer;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getMsgStatus() {
        return this.msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void prepareVideoThumbnail() {
    }

    public boolean isUserMessage() {
        return this.msgType == 21;
    }
}

