/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg;

import java.text.DecimalFormat;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.MediaUtils;

public class FileMessage
extends Message {
    private String videoThumbnail;
    private int[] imageSize;
    private String fileName;
    private long fileSize;

    public FileMessage(int msgType) {
        this(msgType, "");
    }

    public FileMessage(int msgType, String content) {
        super(msgType);
        this.setContent(content);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileInfo(String fileName, long fileSize) {
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    public String getFileSize() {
        DecimalFormat df = new DecimalFormat("#.00");
        String wrongSize = "0B";
        if (this.fileSize == 0L) {
            return wrongSize;
        }
        String fileSizeString = this.fileSize < 1024L ? this.fileSize + "B" : (this.fileSize < 0x100000L ? df.format((double)this.fileSize / 1024.0) + "KB" : (this.fileSize < 0x40000000L ? df.format((double)this.fileSize / 1048576.0) + "MB" : df.format((double)this.fileSize / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    public String getVideoThumbnail() {
        return this.videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        this.setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public void prepareVideoThumbnail() {
        String videoThumbnail = MediaUtils.getImageForVideoSync(this.getContent());
        this.setVideoThumbnail(videoThumbnail);
    }
}

