/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg.base;

import android.text.TextUtils;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.UserMessage;
import org.json.JSONObject;

public class Message {
    public static final int TYPE_TIMESTAMP = 1;
    public static final int TYPE_LOADING = 2;
    public static final int TYPE_AGENT_TEXT = 3;
    public static final int TYPE_AGENT_RPA_FAQ = 4;
    public static final int TYPE_AGENT_BOT_ANSWER = 5;
    public static final int TYPE_AGENT_IMAGE = 6;
    public static final int TYPE_AGENT_VIDEO = 7;
    public static final int TYPE_AGENT_RICH_TEXT = 8;
    public static final int TYPE_AGENT_FILE = 9;
    public static final int TYPE_USER_TEXT = 10;
    public static final int TYPE_USER_IMAGE = 11;
    public static final int TYPE_USER_VIDEO = 12;
    public static final int TYPE_USER_EVALUATE_FAQ = 13;
    public static final int TYPE_USER_FILE = 14;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_SENDING = 2;
    public static final int STATUS_FAILURE = 3;
    private boolean isNormalMessage;
    private boolean isDuringRPAProcedure = true;
    private JSONObject requestParams;
    private boolean enableInteraction = true;
    protected long timestamp;
    protected int msgType;
    protected int msgStatus = 1;
    protected String content;
    protected String nickname;

    public Message() {
        this.setMsgStatus(1);
        this.setTimestamp(System.currentTimeMillis());
    }

    public Message(int msgType) {
        this();
        this.msgType = msgType;
    }

    public boolean isEnableInteraction() {
        return this.enableInteraction;
    }

    public void setEnableInteraction(boolean enableInteraction) {
        this.enableInteraction = enableInteraction;
    }

    public boolean isNormalMessage() {
        return this.isNormalMessage;
    }

    public void setNormalMessage(boolean normalMessage) {
        this.isNormalMessage = normalMessage;
    }

    public boolean isDuringRPAProcedure() {
        return this.isDuringRPAProcedure;
    }

    public void setDuringRPAProcedure(boolean duringRPAProcedure) {
        this.isDuringRPAProcedure = duringRPAProcedure;
    }

    public JSONObject getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(JSONObject requestParams) {
        this.requestParams = requestParams;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp > 0L) {
            this.timestamp = timestamp;
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getMsgStatus() {
        return this.msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static Message getDefaultMessage() {
        BotMessage message = new BotMessage("");
        message.setTimestamp(100L);
        String msg = "What can I do for you?";
        if (!TextUtils.isEmpty((CharSequence)Const.CUSTOM_WELCOME_MSG)) {
            msg = Const.CUSTOM_WELCOME_MSG;
        } else if (!TextUtils.isEmpty((CharSequence)CustomConfig.CustomerService.csWelcomeMessage)) {
            msg = CustomConfig.CustomerService.csWelcomeMessage;
        }
        message.setContent(msg);
        return message;
    }

    public static Message getAgentTypingMsg() {
        return new Message(2);
    }

    public static UserMessage getUserTextMsg(String msg) {
        UserMessage message = new UserMessage();
        message.setContent(msg);
        return message;
    }

    public boolean isTimeStampMessage() {
        return this.msgType == 1;
    }

    public boolean isUserMessage() {
        return this.msgType == 10 || this.msgType == 11 || this.msgType == 12 || this.msgType == 13 || this.msgType == 14;
    }

    public boolean isAgentMessage() {
        return this.msgType == 3 || this.msgType == 6 || this.msgType == 7 || this.msgType == 4 || this.msgType == 8 || this.msgType == 5 || this.msgType == 9;
    }

    public boolean isEmptyMessage() {
        return this.msgType <= 0;
    }
}

