/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg.bot;

import android.os.Build;
import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.DeviceInfoUtil;
import org.json.JSONObject;

public class ExternalUrl {
    private final String title;
    private String link;

    public ExternalUrl(String title, String link) {
        this.title = title;
        this.link = link;
        this.getFormattedUrl(link);
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    private void getFormattedUrl(final String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.contains("type=login")) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("modelInfo", (Object)String.format("%s %s", Build.MANUFACTURER, Build.MODEL));
                jsonObject.put("userId", (Object)UserProfile.USER_ID);
                jsonObject.put("serverId", (Object)UserProfile.SERVER_ID);
                jsonObject.put("country", (Object)DeviceInfoUtil.getInstance().getSimCountryIso());
                AIHelpRequest.getInstance().requestPostByJson(API.GET_USER_TOKEN, jsonObject, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        try {
                            String userToken = JsonHelper.optString(new JSONObject(result), "userToken");
                            ExternalUrl.this.link = String.format("%s&clientparam=%s", url, userToken);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

