/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg.bot;

import android.text.TextUtils;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;

public class Faq {
    public static final int FAQ_SOURCE_RPA = 1;
    public static final int FAQ_SOURCE_ANSWER_BOT = 2;
    private final List<FaqData> faqDataList;

    public Faq(boolean isSimilarMatch, List<FaqData> faqDataList) {
        this.faqDataList = faqDataList;
    }

    public List<FaqData> getFaqDataList() {
        return this.faqDataList;
    }

    private static String getFormattedFormUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            return String.format("%s&appId=%s&userId=%s&serverId=%s&platform=%s&sdkVersion=%s&isTicket=1&hasPermission=%s&fromSdk=1&isCustom=1", url, Const.APP_ID, UserProfile.USER_ID, UserProfile.SERVER_ID, 2, "4.3.15", 0);
        }
        return "";
    }

    public static class FaqData {
        private int faqSource;
        private final long mainId;
        private final long contentId;
        private final String faqTitle;
        private final String faqContent;
        private final String template;
        private final String formUrl;
        private final String formTitle;
        private final boolean isSimilarMatch;
        private final boolean isShowMore;
        private boolean isFaqViewed;
        private boolean isFaqEvaluated;

        public FaqData(int faqSource, long mainId, long contentId, String faqTitle, String faqContent, String template, String formUrl, String formTitle, boolean isSimilarMatch, boolean isShowMore) {
            this.faqSource = faqSource;
            this.mainId = mainId;
            this.contentId = contentId;
            this.faqTitle = faqTitle;
            this.faqContent = faqContent;
            this.template = TextUtils.isEmpty((CharSequence)template) ? "" : template.trim();
            this.formUrl = Faq.getFormattedFormUrl(formUrl);
            this.formTitle = formTitle;
            this.isSimilarMatch = isSimilarMatch;
            this.isShowMore = isShowMore;
        }

        public boolean isFaqEvaluated() {
            return this.isFaqEvaluated;
        }

        public void setFaqEvaluated(boolean faqEvaluated) {
            this.isFaqEvaluated = faqEvaluated;
        }

        public boolean isFaqViewed() {
            return this.isFaqViewed;
        }

        public void setFaqViewed(boolean faqViewed) {
            this.isFaqViewed = faqViewed;
        }

        public long getMainId() {
            return this.mainId;
        }

        public long getContentId() {
            return this.contentId;
        }

        public String getFaqContent() {
            return this.faqContent;
        }

        public String getFaqTitle() {
            return this.faqTitle;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getFormUrl() {
            return this.formUrl;
        }

        public String getFormTitle() {
            return this.formTitle;
        }

        public boolean hasAttachedForm() {
            return !TextUtils.isEmpty((CharSequence)this.formUrl) && !TextUtils.isEmpty((CharSequence)this.formTitle);
        }

        public boolean isSimilarMatch() {
            return this.isSimilarMatch;
        }

        public boolean isShowMore() {
            return this.isShowMore;
        }

        public int getFaqSource() {
            return this.faqSource;
        }

        public void setFaqSource(int faqSource) {
            this.faqSource = faqSource;
        }
    }
}

