/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.data.track.data.TrackEntity;
import net.aihelp.data.track.data.TrackHelper;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import org.json.JSONArray;
import org.json.JSONObject;

public class AIHelpEventTracker {
    public JSONArray trackEventArray = new JSONArray();
    public TrackEntity trackEntity = new TrackEntity("", "");
    public List<String> entranceTrackedEvents = new ArrayList<String>();

    private AIHelpEventTracker() {
        this.trackEventArray = new JSONArray();
        this.trackEntity = new TrackEntity("", "");
        this.entranceTrackedEvents = new ArrayList<String>();
    }

    public static AIHelpEventTracker getInstance() {
        return LazyHolder.HOLDER;
    }

    public void setupTrackHandler(String entranceId, String activeId) {
        this.trackEventArray = new JSONArray();
        this.entranceTrackedEvents = new ArrayList<String>();
        this.trackEntity = new TrackEntity(entranceId, activeId);
    }

    public JSONObject getExtendDataForLogin() {
        JSONObject extendData = new JSONObject();
        try {
            if (this.trackEntity != null) {
                extendData.put("entranceId", (Object)this.trackEntity.getEntranceId());
                extendData.put("activeId", (Object)this.trackEntity.getActiveId());
                extendData.put("faqMainId", (Object)this.trackEntity.getFaqMainId());
                extendData.put("faqContentId", (Object)this.trackEntity.getFaqContentId());
                extendData.put("sectionId", (Object)this.trackEntity.getSectionId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return extendData;
    }

    public void setWhenMessageSent() {
        if (this.trackEntity != null) {
            this.trackEntity.setWhenMessageSent(System.currentTimeMillis());
        }
    }

    public void calculateDurationForWaiting() {
        long waitingTime;
        if (this.trackEntity != null && (waitingTime = System.currentTimeMillis() - this.trackEntity.getWhenMessageSent()) > 0L) {
            JSONObject customerServiceDuration = new JSONObject();
            TrackHelper.addTrackData(customerServiceDuration, "stayTime", waitingTime);
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(54, this.trackEntity, customerServiceDuration));
        }
    }

    public void calculateDurationInCustomerService() {
        if (this.trackEntity != null) {
            this.trackEntity.calculateTotalCustomerServiceDuration();
        }
    }

    public void calculateDurationInAIHelp() {
        if (this.trackEntity != null) {
            long totalHelpCenterDuration;
            long totalSDKDuration;
            if (this.trackEntity.getWhenAIHelpVisible() <= 0L) {
                return;
            }
            long totalCustomerServiceDuration = this.trackEntity.getTotalCustomerServiceDuration();
            if (totalCustomerServiceDuration >= 1000L) {
                JSONObject customerServiceDuration = new JSONObject();
                TrackHelper.addTrackData(customerServiceDuration, "stayTime", totalCustomerServiceDuration);
                this.trackEventArray.put((Object)TrackHelper.getCommonParams(53, this.trackEntity, customerServiceDuration));
            }
            if ((totalSDKDuration = System.currentTimeMillis() - this.trackEntity.getWhenAIHelpVisible()) >= 1000L) {
                JSONObject sdkDuration = new JSONObject();
                TrackHelper.addTrackData(sdkDuration, "stayTime", totalSDKDuration);
                this.trackEventArray.put((Object)TrackHelper.getCommonParams(51, this.trackEntity, sdkDuration));
            }
            if ((totalHelpCenterDuration = totalSDKDuration - totalCustomerServiceDuration) >= 1000L) {
                JSONObject helpCenterDuration = new JSONObject();
                TrackHelper.addTrackData(helpCenterDuration, "stayTime", totalHelpCenterDuration);
                this.trackEventArray.put((Object)TrackHelper.getCommonParams(52, this.trackEntity, helpCenterDuration));
            }
        }
        TrackHelper.syncTrack(this.trackEventArray);
    }

    public void checkedFAQInBot(int faqSource, String mainId, String contentId) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "mainId", mainId);
        TrackHelper.addTrackData(jsonObject, "contentId", contentId);
        TrackHelper.addTrackData(jsonObject, "ticketId", TicketStatusTracker.currentTicketId);
        int trackType = faqSource == 1 ? 314 : 313;
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(trackType, this.trackEntity, jsonObject));
        if (this.trackEntity != null) {
            this.trackEntity.setFaqMainId(mainId);
            this.trackEntity.setFaqContentId(contentId);
        }
    }

    public void checkedFAQ(String mainId, String contentId, String title) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "mainId", mainId);
        TrackHelper.addTrackData(jsonObject, "contentId", contentId);
        TrackHelper.addTrackData(jsonObject, "title", title);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(151, this.trackEntity, jsonObject));
        if (this.trackEntity != null) {
            this.trackEntity.setFaqMainId(mainId);
            this.trackEntity.setFaqContentId(contentId);
        }
    }

    public void markedHelpful(String mainId, String contentId, String title) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "mainId", mainId);
        TrackHelper.addTrackData(jsonObject, "contentId", contentId);
        TrackHelper.addTrackData(jsonObject, "title", title);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(152, this.trackEntity, jsonObject));
    }

    public void markedUnhelpful(String mainId, String contentId, String title) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "mainId", mainId);
        TrackHelper.addTrackData(jsonObject, "contentId", contentId);
        TrackHelper.addTrackData(jsonObject, "title", title);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(153, this.trackEntity, jsonObject));
    }

    public void submitSuggestion(String mainId, String contentId, String title, String feedback) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "mainId", mainId);
        TrackHelper.addTrackData(jsonObject, "contentId", contentId);
        TrackHelper.addTrackData(jsonObject, "title", title);
        TrackHelper.addTrackData(jsonObject, "feedback", feedback);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(154, this.trackEntity, jsonObject));
    }

    public void clickServiceEntranceInFaq(String faqContentVisitId) {
        String clickServiceEvent = String.format("%s-%s", 155, faqContentVisitId);
        if (!this.entranceTrackedEvents.contains(clickServiceEvent)) {
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(155, this.trackEntity, new JSONObject[0]));
            this.entranceTrackedEvents.add(clickServiceEvent);
        }
    }

    public void trackSearchQuery(String searchContent) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "content", searchContent);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(156, this.trackEntity, jsonObject));
    }

    public void onFormClicked(String formUrl) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "formId", this.getFormIdFromUrl(formUrl));
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(252, this.trackEntity, jsonObject));
    }

    public void onFormSubmitted(String formId) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "formId", formId);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(253, this.trackEntity, jsonObject));
    }

    private String getFormIdFromUrl(String formUrl) {
        Matcher formIdFilter = Pattern.compile("(?<=(formId=))((?!&).)*").matcher(formUrl);
        if (formIdFilter.find()) {
            return formIdFilter.group();
        }
        return "";
    }

    public void clickSearch() {
        String searchClickEvent = String.format("%s", 101);
        if (!this.entranceTrackedEvents.contains(searchClickEvent)) {
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(101, this.trackEntity, new JSONObject[0]));
            this.entranceTrackedEvents.add(searchClickEvent);
        }
    }

    public void clickNotification(String mainId, String contentId, String title) {
        this.clickSomeFaq(102, mainId, contentId, title);
    }

    public void clickHotTopic(String mainId, String contentId, String title) {
        this.clickSomeFaq(103, mainId, contentId, title);
    }

    public void clickFaq(String mainId, String contentId, String title) {
        this.clickSomeFaq(105, mainId, contentId, title);
    }

    public void clickSection(String sectionId, String title) {
        String clickSectionEvent = String.format("%s-%s", 104, sectionId);
        if (!this.entranceTrackedEvents.contains(clickSectionEvent)) {
            JSONObject jsonObject = new JSONObject();
            TrackHelper.addTrackData(jsonObject, "sectionId", sectionId);
            TrackHelper.addTrackData(jsonObject, "title", title);
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(104, this.trackEntity, jsonObject));
            this.entranceTrackedEvents.add(clickSectionEvent);
        }
        if (this.trackEntity != null) {
            this.trackEntity.setSectionId(sectionId);
        }
    }

    private void clickSomeFaq(int type, String mainId, String contentId, String title) {
        String clickHotTopicEvent = String.format("%s-%s", type, contentId);
        if (!this.entranceTrackedEvents.contains(clickHotTopicEvent)) {
            JSONObject jsonObject = new JSONObject();
            TrackHelper.addTrackData(jsonObject, "mainId", mainId);
            TrackHelper.addTrackData(jsonObject, "contentId", contentId);
            TrackHelper.addTrackData(jsonObject, "title", title);
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(type, this.trackEntity, jsonObject));
            this.entranceTrackedEvents.add(clickHotTopicEvent);
        }
    }

    public void clickServiceEntrance(String faqContentVisitId) {
        this.showCustomerService(false);
        String clickServiceEvent = String.format("%s", 106);
        if (!this.entranceTrackedEvents.contains(clickServiceEvent)) {
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(106, this.trackEntity, new JSONObject[0]));
            this.entranceTrackedEvents.add(clickServiceEvent);
        }
        this.clickServiceEntranceInFaq(faqContentVisitId);
    }

    public void showAIHelp() {
        this.trackEntity.setWhenAIHelpVisible(System.currentTimeMillis());
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(1, this.trackEntity, new JSONObject[0]));
    }

    public void showHelpCenter() {
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(2, this.trackEntity, new JSONObject[0]));
    }

    public void showCustomerService(boolean alwaysTrack) {
        this.trackEntity.setWhenCustomerServiceVisible(System.currentTimeMillis());
        if (alwaysTrack || !this.trackEntity.isTracked()) {
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(3, this.trackEntity, new JSONObject[0]));
            this.trackEntity.setTracked(true);
        }
    }

    public void selectSmartIntent(String intentId) {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "intentId", intentId);
        TrackHelper.addTrackData(jsonObject, "ticketId", TicketStatusTracker.currentTicketId);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(201, this.trackEntity, jsonObject));
    }

    public void onUserInput() {
        if (!TicketStatusTracker.isTicketActive || TicketStatusTracker.isTicketServingByAnswerBot()) {
            JSONObject jsonObject = new JSONObject();
            TrackHelper.addTrackData(jsonObject, "ticketId", TicketStatusTracker.currentTicketId);
            this.trackEventArray.put((Object)TrackHelper.getCommonParams(202, this.trackEntity, jsonObject));
        }
    }

    public void onAnswerBotSelected() {
        JSONObject jsonObject = new JSONObject();
        TrackHelper.addTrackData(jsonObject, "ticketId", TicketStatusTracker.currentTicketId);
        this.trackEventArray.put((Object)TrackHelper.getCommonParams(204, this.trackEntity, jsonObject));
    }

    private static class LazyHolder {
        static final AIHelpEventTracker HOLDER = new AIHelpEventTracker();

        private LazyHolder() {
        }
    }
}

