/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track;

import android.text.TextUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import org.json.JSONObject;

public class ResourceLoadTracker {
    private static final int RESOURCE_REQUEST_THRESHOLD = 5000;
    private boolean isInitSuccess;
    private long initStartTime;
    private long initEndTime;
    private long initDuration;
    private int resourceCount;
    private ConcurrentHashMap<String, Long> resourceLoadingMap = new ConcurrentHashMap();
    private static ResourceLoadTracker sInstance;

    public void markInitStarted() {
        this.reset();
        this.initStartTime = System.currentTimeMillis();
    }

    public void markInitEnded(boolean initSuccess) {
        this.isInitSuccess = initSuccess;
        this.initEndTime = System.currentTimeMillis();
        this.initDuration = this.initEndTime - this.initStartTime;
        if (!initSuccess) {
            AIHelpRequest request = AIHelpRequest.getInstance();
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME, this.getTrackData(-1L), null);
        }
    }

    public void onResourceRequested(int resourceCount) {
        this.resourceCount = resourceCount;
    }

    public void onResourceRetrieved(int mode, boolean isSuccess) {
        --this.resourceCount;
        String key = LocalizeUtil.getFolderName(mode).replace("/", "");
        long loadingDuration = System.currentTimeMillis() - this.initEndTime;
        this.resourceLoadingMap.put(key, isSuccess ? loadingDuration : -1L);
        if (this.resourceCount <= 0) {
            AIHelpRequest request = AIHelpRequest.getInstance();
            if (loadingDuration >= 5000L) {
                request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME, this.getTrackData(loadingDuration), null);
            } else {
                request.requestPostByJson(API.TRACK_LOCALIZE_DURATION, this.getTrackData(loadingDuration), null);
            }
        }
    }

    private JSONObject getTrackData(long loadingDuration) {
        JSONObject trackData = this.getCommonParams();
        JsonHelper.put(trackData, "success", this.isInitSuccess);
        JsonHelper.put(trackData, "initLoadingTime", this.initDuration);
        JsonHelper.put(trackData, "sdkSettingLoadingTime", loadingDuration);
        JSONObject sdkSettingDict = JsonHelper.getJsonObject();
        Set resourceKeys = this.resourceLoadingMap.keySet();
        for (String resourceKey : resourceKeys) {
            Long duration = this.resourceLoadingMap.get(resourceKey);
            if (TextUtils.isEmpty((CharSequence)resourceKey) || duration == null) continue;
            JsonHelper.put(sdkSettingDict, resourceKey, duration);
        }
        JsonHelper.put(trackData, "sdkSettingDict", sdkSettingDict);
        return trackData;
    }

    private JSONObject getCommonParams() {
        JSONObject map = new JSONObject();
        try {
            map.put("time", (Object)String.valueOf(System.currentTimeMillis()));
            map.put("deviceId", (Object)DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("countryCode", (Object)DeviceInfoUtil.getInstance().getSimCountryIso());
            map.put("userId", (Object)UserProfile.USER_ID);
            map.put("platform", 2);
            map.put("lan", (Object)Const.CORRECT_LANGUAGE);
            map.put("appId", (Object)Const.APP_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void reset() {
        this.isInitSuccess = false;
        this.initStartTime = 0L;
        this.initEndTime = 0L;
        this.resourceLoadingMap = new ConcurrentHashMap();
    }

    private ResourceLoadTracker() {
        this.reset();
    }

    public static ResourceLoadTracker getInstance() {
        if (sInstance == null) {
            sInstance = new ResourceLoadTracker();
        }
        return sInstance;
    }
}

