/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.config.ApiConfig;
import net.aihelp.config.UserConfig;
import net.aihelp.config.enums.PublishCountryOrRegion;
import net.aihelp.config.enums.PushPlatform;
import net.aihelp.config.enums.ShowConversationMoment;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.net.monitor.NetworkMonitorManager;
import net.aihelp.core.ui.ActivityManager;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.crash.AIHelpCrashHandler;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.logic.InitPresenter;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.exception.AIHelpInitException;
import net.aihelp.init.InitHelper;
import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;
import net.aihelp.ui.webkit.WebViewUtil;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SchemaUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

class AIHelpCore {
    private Object refWatcher;
    private WeakReference<Activity> mActivity;
    private Context mAppContext;
    private InitPresenter mInitPresenter;

    public void init(final Context context, String appKey, String domain, String appId, final String language) throws AIHelpInitException {
        try {
            final String trimApiKey = !TextUtils.isEmpty((CharSequence)appKey) ? appKey.trim() : appKey;
            final String trimDomain = !TextUtils.isEmpty((CharSequence)domain) ? domain.trim() : domain;
            final String trimAppId = this.generateAppIdFromAppKey(appKey, domain, appId);
            SchemaUtil.validateInitializeCredentials(context, trimApiKey, trimDomain, trimAppId);
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (context instanceof Activity) {
                        AIHelpCore.this.mActivity = new WeakReference<Activity>((Activity)context);
                    }
                    AIHelpCore.this.mAppContext = context.getApplicationContext();
                    AIHelpContext.getInstance().setContext(AIHelpCore.this.mAppContext);
                    AIHelpCrashHandler.INSTANCE.init(AIHelpCore.this.mAppContext);
                    WebViewUtil.prepareDataDirectorySuffix(AIHelpCore.this.mAppContext);
                    AIHelpCore.this.mInitPresenter = new InitPresenter(AIHelpCore.this.mAppContext, trimApiKey, trimDomain, trimAppId, language);
                    if (SpUtil.getInstance().getBoolean("sp_log_toggle")) {
                        TLog.initLog(true);
                    }
                    NetworkMonitorManager.getInstance().init(AIHelpCore.this.mAppContext);
                    InitHelper.getInstance().runInitRelatedTask(AIHelpCore.this.mAppContext);
                }
            });
        }
        catch (AIHelpInitException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateAppIdFromAppKey(String appKey, String domain, String appId) {
        if (TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey) && !TextUtils.isEmpty((CharSequence)domain)) {
            String updatedDomain = domain.replace("https://", "").replace("http://", "");
            String newAppKey = HttpConfig.md5(appKey.toLowerCase() + "AIHelpSDKToAndroidAppId");
            String newDomain = updatedDomain.toLowerCase().substring(0, updatedDomain.indexOf("."));
            return newDomain + "_platform_" + newAppKey;
        }
        return appId.trim();
    }

    boolean show(ApiConfig apiConfig) {
        if (this.isInitStillInProgress()) {
            return false;
        }
        ProcessEntity process = ProcessEntranceHelper.INSTANCE.getProcess(apiConfig.getEntranceId());
        Const.CUSTOM_WELCOME_MSG = apiConfig.getWelcomeMessage();
        switch (process.getIntent()) {
            case 1: {
                this.showHelpCenter(process);
                break;
            }
            case 2: {
                this.showFAQSection(process);
                break;
            }
            case 3: {
                this.showSingleFAQ(process);
                break;
            }
            case 4: {
                this.showCustomerService();
                break;
            }
            default: {
                this.showErrorEntrancePage();
            }
        }
        return true;
    }

    private void showErrorEntrancePage() {
        Intent errorEntranceIntent = IntentValues.getShowErrorEntranceIntent(this.mAppContext);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(errorEntranceIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(errorEntranceIntent));
        }
    }

    void showHelpCenter(ProcessEntity process) {
        Intent showFAQIntent = IntentValues.getShowFAQIntent(this.mAppContext, process);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(showFAQIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showFAQIntent));
        }
    }

    void showFAQSection(ProcessEntity process) {
        Intent showFAQSectionIntent = IntentValues.getShowFAQSectionIntent(this.mAppContext, process);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(showFAQSectionIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showFAQSectionIntent));
        }
    }

    void showSingleFAQ(ProcessEntity process) {
        Intent showSingleFAQIntent = IntentValues.getShowSingleFAQIntent(this.mAppContext, process);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(showSingleFAQIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showSingleFAQIntent));
        }
    }

    void showSingleFAQ(String faqId, ShowConversationMoment moment) {
        Intent showSingleFAQIntent = IntentValues.getShowSingleFAQIntent(this.mAppContext, faqId, moment);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(showSingleFAQIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showSingleFAQIntent));
        }
    }

    void showCustomerService() {
        Intent showSupportIntent = IntentValues.getShowCustomerServiceIntent(this.mAppContext);
        if (this.mActivity != null && this.mActivity.get() != null) {
            ((Activity)this.mActivity.get()).startActivity(showSupportIntent);
        } else {
            this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showSupportIntent));
        }
    }

    void updateSDKLanguage(String sdkLanguage) {
        try {
            if (this.isInitStillInProgress()) {
                return;
            }
            this.mInitPresenter.updateSDKLanguage(sdkLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showUrl(String url) {
        if (this.mAppContext != null && !TextUtils.isEmpty((CharSequence)url)) {
            Intent showUrlIntent = IntentValues.getUrlIntent(this.mAppContext, url);
            if (this.mActivity != null && this.mActivity.get() != null) {
                ((Activity)this.mActivity.get()).startActivity(showUrlIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showUrlIntent));
            }
        } else {
            TLog.d("AIHelp", "AIHelpSupport showUrl illegal argument");
        }
    }

    void updateUserInfo(UserConfig config) {
        if (this.isPresenterStillNull()) {
            return;
        }
        this.mInitPresenter.updateUserProfile(config);
    }

    void setUploadLogPath(String logPath) {
        if (this.isPresenterStillNull()) {
            return;
        }
        this.mInitPresenter.setUploadLogPath(logPath);
    }

    void setNetworkCheckHostAddress(String hostAddress, OnNetworkCheckResultCallback listener) {
        if (this.isPresenterStillNull()) {
            return;
        }
        this.mInitPresenter.setNetworkCheckHostAddress(hostAddress, listener);
    }

    void setPushTokenAndPlatform(String pushToken, PushPlatform pushPlatform) {
        if (this.isPresenterStillNull() || pushPlatform == null) {
            return;
        }
        UserProfile.PUSH_TOKEN = pushToken;
        UserProfile.PUSH_PLATFORM = pushPlatform.getValue();
        this.mInitPresenter.postCrmPushTokenInfo();
    }

    void additionalSupportFor(PublishCountryOrRegion countryOrRegion) {
        Const.countryOrRegion = countryOrRegion;
    }

    void startUnreadMessageCountPolling(OnMessageCountArrivedCallback listener) {
        if (this.isPresenterStillNull()) {
            return;
        }
        this.mInitPresenter.startUnreadMessagePolling(listener);
    }

    void stopUnreadMessageCountPolling() {
        if (this.isPresenterStillNull()) {
            return;
        }
        this.mInitPresenter.stopUnreadMessagePolling();
    }

    void setOnSpecificFormSubmittedCallback(OnSpecificFormSubmittedCallback callback) {
        Const.sSpecificFormSubmittedListener = callback;
    }

    void setOnAIHelpSessionOpenCallback(OnAIHelpSessionOpenCallback callback) {
        Const.sSessionOpenListener = callback;
    }

    void setOnAIHelpSessionCloseCallback(OnAIHelpSessionCloseCallback callback) {
        Const.sSessionCloseListener = callback;
    }

    void setOnAIHelpInitializedCallback(OnAIHelpInitializedCallback listener) {
        Const.sInitializedListener = listener;
    }

    void setOnSpecificUrlClickedCallback(OnSpecificUrlClickedCallback callback) {
        Const.sOnSpecificUrlClickedListener = callback;
    }

    void close() {
        ActivityManager.INSTANCE.finishAll();
    }

    void enableLogging(boolean enable) {
        TLog.initLog(enable);
    }

    private boolean isInitStillInProgress() {
        if (!AIHelpContext.successfullyInit.get()) {
            Log.e((String)"AIHelp", (String)"AIHelp is during initialization process at this time, the API you called is not available, please try again later.");
            return true;
        }
        if (!AppInfoUtil.isNetworkAvailable(this.mAppContext)) {
            ToastUtil.INSTANCE.makeRawToast(this.mAppContext, ResResolver.getString("aihelp_network_no_connect"));
            return true;
        }
        return false;
    }

    private boolean isPresenterStillNull() {
        if (this.mInitPresenter == null) {
            Log.e((String)"AIHelp", (String)"Please ensure AIHelpSupport#init is called at the very first place before you call any other API.");
            return true;
        }
        return false;
    }

    private void installLeakCanary(Application app) {
        if (app != null) {
            // empty if block
        }
    }

    public static AIHelpCore getInstance() {
        return Holder.INSTANCE;
    }

    private AIHelpCore() {
    }

    private static class Holder {
        private static final AIHelpCore INSTANCE = new AIHelpCore();

        private Holder() {
        }
    }
}

