/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.logic.RequestRetryHandler;
import net.aihelp.data.model.init.InitEntity;
import net.aihelp.data.track.ResourceLoadTracker;
import net.aihelp.ui.helper.MessageSyncHelper;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.SpUtil;
import org.json.JSONObject;

public class InitHelper
implements RequestRetryHandler.OnRetryRequestListener {
    public static final int ERROR_INVALID_APP_ID = 4100;
    private static InitHelper sInstance;
    private final RequestRetryHandler mRetryHandler = new RequestRetryHandler(this, 5);
    private boolean requireCallback;

    private InitHelper() {
    }

    public static InitHelper getInstance() {
        if (sInstance == null) {
            sInstance = new InitHelper();
        }
        return sInstance;
    }

    public void runInitRelatedTask(final Context context) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                InitHelper.this.goLogDauStatus(context);
                InitHelper.this.requestInit(true);
                MessageSyncHelper.syncLogMessage();
            }
        });
    }

    public void onAIHelpInitializedCallback(final boolean isSuccess, final String message) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                AIHelpContext.successfullyInit.set(isSuccess);
                if (InitHelper.this.requireCallback && Const.sInitializedListener != null) {
                    Const.sInitializedListener.onAIHelpInitialized(isSuccess, message);
                    Const.sInitializedListener = null;
                }
            }
        }, 200L);
    }

    private void goLogDauStatus(Context context) {
        long initTime = SpUtil.getInstance().getLong("sp_log_dau_time");
        if (!DateFormatUtil.isToday(initTime)) {
            try {
                JSONObject dauParams = new JSONObject();
                dauParams.put("deviceid", (Object)DeviceUuidFactory.id(context));
                AIHelpRequest.getInstance().requestPostByJson(API.LOG_DAU_URL, dauParams, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        SpUtil.getInstance().put("sp_log_dau_time", System.currentTimeMillis());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void requestInit(boolean requireCallback) {
        this.requireCallback = requireCallback;
        String spPrefix = String.format("%s_%s_", Const.APP_ID, Const.ORIGINAL_LANGUAGE);
        final long lastInitTime = SpUtil.getInstance().getLong(spPrefix + "init_timestamp", System.currentTimeMillis());
        int requestLimit = SpUtil.getInstance().getInt(spPrefix + "init_limit");
        final String cachedInitData = SpUtil.getInstance().getString(spPrefix + "init_response");
        LocalizeHelper.resetLocalizeData();
        if (TextUtils.isEmpty((CharSequence)cachedInitData) || requestLimit < 0 || System.currentTimeMillis() - lastInitTime > (long)requestLimit) {
            ResourceLoadTracker.getInstance().markInitStarted();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("domain", (Object)API.HOST_URL);
                AIHelpRequest.getInstance().requestGetByAsync(API.INIT_URL, jsonObject, new ReqCallback<String>(){

                    @Override
                    public void onAsyncReqSuccess(String result) {
                        if (InitHelper.this.mRetryHandler != null) {
                            InitHelper.this.mRetryHandler.removeCallbacksAndMessages(null);
                        }
                        InitHelper.this.cacheInitResponse(result, System.currentTimeMillis());
                    }

                    @Override
                    public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                        switch (errorCode) {
                            case 4100: {
                                InitHelper.this.onAIHelpInitializedCallback(false, "Invalid init parameters");
                                break;
                            }
                            default: {
                                ResourceLoadTracker.getInstance().markInitEnded(false);
                                if (TextUtils.isEmpty((CharSequence)cachedInitData)) {
                                    if (InitHelper.this.mRetryHandler == null) break;
                                    InitHelper.this.mRetryHandler.handleRetryRequest(errorCode, errorMsg);
                                    break;
                                }
                                InitHelper.this.cacheInitResponse(cachedInitData, lastInitTime);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.cacheInitResponse(cachedInitData, lastInitTime);
        }
    }

    private void cacheInitResponse(String initResponse, long lastInitTime) {
        InitEntity initEntity = JsonHelper.toJavaObject(initResponse, InitEntity.class);
        if (initEntity != null) {
            String[] faqMqtt;
            int cachePeriod = initEntity.getRequestLimit();
            String spPrefix = String.format("%s_%s_", Const.APP_ID, Const.ORIGINAL_LANGUAGE);
            SpUtil.getInstance().put(spPrefix + "init_limit", cachePeriod < 0 ? cachePeriod : cachePeriod * 60 * 1000);
            SpUtil.getInstance().put(spPrefix + "init_response", initResponse);
            SpUtil.getInstance().put(spPrefix + "init_timestamp", lastInitTime);
            API.CDN_URL = initEntity.getCdnUrl();
            API.FAQ_URL = initEntity.getFaqdata();
            API.OP_URL = initEntity.getFaqYYdata();
            API.UPLOAD_IMAGE_URL = initEntity.getUpload();
            API.UPLOAD_VIDEO_URL = initEntity.getUploadVideo();
            API.UPLOAD_LOG_URL = initEntity.getUploadLog();
            API.UPLOAD_ATTACHMENT_URL = initEntity.getUploadFile();
            API.M_FAQ_URL = initEntity.getShowfaq();
            API.LOG_COUNT_URL = initEntity.getPoint();
            API.LOCALE_FILE_URL = initEntity.getLocaleFile();
            API.CONFIG_STYLE_SHEET_URL = initEntity.getConfigStyle();
            API.CONFIG_BUSINESS_LOGIC_URL = initEntity.getConfigBusiness();
            API.CONFIG_OPINION_URL = initEntity.getSatisfyFeedback();
            API.CONFIG_FAQ_HOT_TOPIC_URL = initEntity.getConfigFaq();
            API.CONFIG_PROCESS_URL = initEntity.getConfigProcess();
            API.CONFIG_TEXT_URL = initEntity.getConfigText();
            API.CONFIG_UPLOAD_LIMIT_URL = initEntity.getSdkCustomUpload();
            API.MQTT_IP = initEntity.getSvrip();
            API.MQTT_PORT = initEntity.getSvrport();
            API.MQTT_TOPIC = initEntity.getTopic();
            if (!TextUtils.isEmpty((CharSequence)initEntity.getPushServer()) && (faqMqtt = initEntity.getPushServer().split(":")).length == 2) {
                API.MQTT_FAQ_IP = faqMqtt[0];
                API.MQTT_FAQ_PORT = faqMqtt[1];
            }
            Const.TOGGLE_UPLOAD_VIDEO = initEntity.isOpenVideoUpload();
            Const.TOGGLE_CRM_TOKEN = initEntity.isSetCrmToken();
            Const.TOGGLE_OPEN_FAQ_NOTIFICATION = initEntity.isOpenPushServer();
            Const.TOGGLE_OPEN_UNREAD_MSG = initEntity.isUnreadMessage();
            Const.TOGGLE_UPLOAD_LOG = initEntity.isOpenUploadLogFile();
            Const.TOGGLE_LOCALIZE_VIA_INIT = initEntity.isLocalizeFAQViaInit();
            Const.TOGGLE_MQTT_TLS = initEntity.isTls();
            Const.TOGGLE_TRANSLATE_CS_MESSAGE = initEntity.isTranslates();
            Const.TOGGLE_DISTINGUISH_USER_BY_DEVICE = initEntity.isDistinguishUserByDevice();
            Const.FAQ_FILE = initEntity.getFaqFileName();
            Const.STORY_FILE = initEntity.getStoryAimlFileName();
            Const.OP_FILE = initEntity.getOperateFileName();
            Const.LIMIT_CHECKING_UNREAD = initEntity.getUnreadMessageTime();
            Const.APP_SHOW_NAME = AppInfoUtil.getAppName(AIHelpContext.getInstance().getContext());
            if (!TextUtils.isEmpty((CharSequence)initEntity.getCorrectLanguage())) {
                Const.CORRECT_LANGUAGE = initEntity.getCorrectLanguage();
            }
            if (initEntity.getNetworkCheckSetting() != null) {
                Const.TOGGLE_NET_CHECK = true;
                Const.NET_TRACE_ROUTE = initEntity.getNetworkCheckSetting().getTraceroute();
                Const.NET_PING = initEntity.getNetworkCheckSetting().getPing();
            }
            ResourceLoadTracker.getInstance().markInitEnded(true);
            LocalizeHelper.goFetchLocalizeData();
            if (this.requireCallback) {
                Log.e((String)"AIHelp", (String)"AIHelp is now ready to help you have conversations with your users!");
            }
        }
    }

    @Override
    public void onRetryRequest() {
        this.requestInit(true);
    }

    @Override
    public void onRetryUpToMaxCount(int code, String errorMsg) {
        this.onAIHelpInitializedCallback(false, errorMsg);
    }
}

