/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatRadioButton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.cs.storyline.BotBillEntity;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public class BillingListAdapter
extends BaseAdapter {
    private final Context mContext;
    private final boolean isEnableSend;
    private final List<BotBillEntity> mBillingList = new ArrayList<BotBillEntity>();
    private BotBillEntity mCurrentCheckedEntity;
    private OnOrderCheckedListener listener;

    public BillingListAdapter(Context context, boolean isEnableSend) {
        this.isEnableSend = isEnableSend;
        this.mContext = context;
    }

    public void update(JSONArray jsonArray) {
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.mBillingList.add(new BotBillEntity(jsonArray.optString(i)));
            }
            this.notifyDataSetChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TextView getBillInfo(String jsonString, String key) {
        TextView textView = new TextView(this.mContext);
        textView.setTextSize(2, 14.0f);
        textView.setPadding(0, 7, 0, 7);
        try {
            JSONObject billItem = new JSONObject(jsonString);
            String value = billItem.optString(key);
            ForegroundColorSpan keySpan = new ForegroundColorSpan(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5));
            ForegroundColorSpan valueSpan = new ForegroundColorSpan(Styles.getColor(CustomConfig.CommonSetting.textColor));
            SpannableStringBuilder builder = new SpannableStringBuilder();
            builder.append((CharSequence)key).append((CharSequence)": ");
            builder.setSpan((Object)keySpan, 0, key.length(), 33);
            builder.append((CharSequence)value);
            builder.setSpan((Object)valueSpan, key.length(), key.length() + 1 + ": ".length() + value.length() - 1, 33);
            if (Build.VERSION.SDK_INT >= 17) {
                textView.setTextDirection(5);
            }
            textView.setText((CharSequence)builder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textView;
    }

    private ArrayList<String> getSortedKeys(String s) {
        ArrayList<String> keyList = new ArrayList<String>();
        try {
            JSONObject billItem = new JSONObject(s);
            Iterator iterator = billItem.keys();
            while (iterator.hasNext()) {
                keyList.add((String)iterator.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyList;
    }

    public int getCount() {
        return this.mBillingList.size();
    }

    public BotBillEntity getItem(int position) {
        return this.mBillingList.size() == 0 ? null : this.mBillingList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)ResResolver.getLayoutId("aihelp_ada_billing_list"), null);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        final BotBillEntity botBillEntity = this.mBillingList.get(position);
        holder.vDivider.setVisibility(position == 0 ? 8 : 0);
        holder.vDivider.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1));
        holder.radioButton.setBackground((Drawable)Styles.makeSelector(this.mContext));
        holder.radioButton.setChecked(botBillEntity.isChecked());
        holder.billContainer.removeAllViews();
        ArrayList<String> sortedKeys = this.getSortedKeys(botBillEntity.getOriginJson());
        for (String key : sortedKeys) {
            holder.billContainer.addView((View)this.getBillInfo(botBillEntity.getOriginJson(), key));
        }
        if (this.isEnableSend) {
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BillingListAdapter.this.mCurrentCheckedEntity != null) {
                        BillingListAdapter.this.mCurrentCheckedEntity.setChecked(false);
                    }
                    botBillEntity.setChecked(true);
                    BillingListAdapter.this.mCurrentCheckedEntity = botBillEntity;
                    BillingListAdapter.this.notifyDataSetChanged();
                    if (BillingListAdapter.this.listener != null) {
                        BillingListAdapter.this.listener.onOrderChecked();
                    }
                }
            });
        } else {
            holder.radioButton.setVisibility(8);
        }
        return convertView;
    }

    public String getCheckedBill() {
        if (this.mCurrentCheckedEntity != null) {
            return this.mCurrentCheckedEntity.getOriginJson();
        }
        return "";
    }

    public void setOnOrderCheckedListener(OnOrderCheckedListener listener) {
        this.listener = listener;
    }

    public static interface OnOrderCheckedListener {
        public void onOrderChecked();
    }

    private static class ViewHolder {
        private final View vDivider;
        private final LinearLayout billContainer;
        private final AppCompatRadioButton radioButton;

        private ViewHolder(View convertView) {
            this.vDivider = convertView.findViewById(ResResolver.getViewId("aihelp_bill_divider"));
            this.billContainer = (LinearLayout)convertView.findViewById(ResResolver.getViewId("aihelp_ll_bill"));
            this.radioButton = (AppCompatRadioButton)convertView.findViewById(ResResolver.getViewId("aihelp_rb_bill"));
        }
    }
}

