/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.FormUrl;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.URLEncodeUtil;
import net.aihelp.utils.UploadFileHelper;

public abstract class BaseMsgAdapter
implements ItemViewDelegate<Message> {
    protected final Context mContext;
    protected final Fragment mFragment;
    protected MessageListAdapter.OnClickedListenerWrapper mWrapper;
    protected List<Message> dataList = new ArrayList<Message>();
    protected boolean isCurrentRtl;

    public BaseMsgAdapter(Context context) {
        this(context, null);
    }

    public BaseMsgAdapter(Context context, Fragment fragment) {
        this.mContext = context;
        this.mFragment = fragment;
        if (Build.VERSION.SDK_INT >= 17) {
            this.isCurrentRtl = context.getResources().getConfiguration().getLayoutDirection() == 1;
        }
    }

    protected View.OnClickListener getRetryListener(final int position, final Message message) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (BaseMsgAdapter.this.mWrapper != null) {
                    message.setTimestamp(System.currentTimeMillis());
                    message.setMsgStatus(message instanceof FileMessage ? 2 : 1);
                    BaseMsgAdapter.this.mWrapper.onRetrySendingMessage(position, message);
                }
            }
        };
    }

    protected View.OnClickListener getFileRetryListener(final int position, final Message message) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (BaseMsgAdapter.this.mWrapper != null) {
                    message.setTimestamp(System.currentTimeMillis());
                    message.setMsgStatus(2);
                    BaseMsgAdapter.this.mWrapper.onRetrySendingMessage(position, message);
                    UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener(){

                        @Override
                        public void onFileUploaded(String fileUrl) {
                            boolean isUrlValid = !TextUtils.isEmpty((CharSequence)fileUrl);
                            message.setContent(isUrlValid ? fileUrl : message.getContent());
                            message.setMsgStatus(isUrlValid ? 1 : 3);
                            BaseMsgAdapter.this.mWrapper.onRetrySendingMessage(position, message);
                        }
                    }).performUpload(new File(message.getContent()));
                }
            }
        };
    }

    protected Drawable getAdminBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15) : Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15);
    }

    public void setOnClickedListenerWrapper(MessageListAdapter.OnClickedListenerWrapper mWrapper) {
        this.mWrapper = mWrapper;
    }

    protected TextView getMsg(String botMsg, boolean enableInteraction) {
        boolean isSamsungOreo;
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)botMsg) && botMsg.contains("&formUrlTitle=") && (matcher = Pattern.compile("(http:|https:)(//)((?!\").)*?(&formUrlTitle=)*?").matcher(botMsg)).matches()) {
            botMsg = botMsg + "&fromSdk=1&isCustom=1";
            Matcher subMatcher = Pattern.compile("(?<=(formUrlTitle=)).*(?=(&fromSdk=1&isCustom=1))").matcher(botMsg);
            String formTitle = botMsg;
            if (subMatcher.find()) {
                formTitle = URLEncodeUtil.decode(subMatcher.group());
            }
            final FormUrl formUrl = new FormUrl(formTitle, botMsg);
            return this.getHighlightedClickableTextView(formUrl.getTitle(), new View.OnClickListener(){

                public void onClick(View v) {
                    String urlLink = formUrl.getLink();
                    if (AppInfoUtil.isUrlStillNeedResponding(BaseMsgAdapter.this.mContext, urlLink) && BaseMsgAdapter.this.mWrapper != null) {
                        BaseMsgAdapter.this.mWrapper.onUrlClicked(true, urlLink);
                    }
                }
            });
        }
        TextView textView = new TextView(this.mContext);
        textView.setTextSize(15.0f);
        textView.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        textView.setTextIsSelectable(true);
        boolean isMIUI12 = ("XiaoMi".equalsIgnoreCase(Build.MANUFACTURER) || "RedMi".equalsIgnoreCase(Build.MANUFACTURER)) && Build.VERSION.SDK_INT == 30;
        boolean bl = isSamsungOreo = "samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.VERSION.SDK_INT <= 26;
        if (isMIUI12 || isSamsungOreo) {
            textView.setText((CharSequence)botMsg);
        } else {
            textView.setText((CharSequence)this.getUrlSupportedText(botMsg));
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        return textView;
    }

    protected TextView getHighlightedClickableTextView(String text, View.OnClickListener onClickListener) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)text);
        textView.setTextSize(14.0f);
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 5.0));
        textView.setOnClickListener(onClickListener);
        return textView;
    }

    @Override
    public void onDataSourceUpdated(List<Message> data) {
    }

    protected SpannableStringBuilder getUrlSupportedText(String msg) {
        return this.getUrlSupportedText(msg, CustomConfig.CommonSetting.interactElementTextColor);
    }

    protected SpannableStringBuilder getUrlSupportedText(String msg, final String urlColor) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return new SpannableStringBuilder((CharSequence)"");
        }
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)msg);
        Matcher matcher = Pattern.compile("\\S+(://)\\S+").matcher((CharSequence)ssb);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            final String urlStr = matcher.group();
            ClickableSpan clickableSpan = new ClickableSpan(){

                public void onClick(View view) {
                    if (AppInfoUtil.isUrlStillNeedResponding(BaseMsgAdapter.this.mContext, urlStr) && BaseMsgAdapter.this.mWrapper != null) {
                        BaseMsgAdapter.this.mWrapper.onUrlClicked(false, urlStr);
                    }
                }

                public void updateDrawState(TextPaint dp) {
                    dp.setColor(Color.parseColor((String)urlColor));
                }
            };
            ssb.setSpan((Object)clickableSpan, start, end, 34);
            ssb.setSpan((Object)new UnderlineSpan(), start, end, 34);
        }
        return ssb;
    }

    protected int getViewId(String name) {
        return ResResolver.getViewId(name);
    }

    protected int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }
}

