/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import java.util.List;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Answer;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.adapter.cs.agent.AgentFaqAdapter;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.widget.AIHelpEvaluateButtonView;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class AgentAnswerAdapter
extends AgentFaqAdapter {
    private AIHelpEvaluateButtonView mEvaluateButtonView;

    public AgentAnswerAdapter(Context context) {
        super(context);
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 5;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        BotMessage botMessage;
        super.convert(holder, message, position);
        if (message instanceof BotMessage && (botMessage = (BotMessage)message).hasBotAnswers()) {
            List<Answer> botAnswers = botMessage.getBotAnswers();
            if (this.isSingleFaqMatched(botMessage)) {
                this.llContainer.removeAllViews();
                Answer answer = ((BotMessage)message).getBotAnswers().get(0);
                this.llContainer.addView(this.getSingleFAQItem(botMessage, answer.getFaqData()));
                if (answer.getFaqData().hasAttachedForm()) {
                    this.prepareFaqFormLayout(this.llContainer, answer.getFaqData());
                }
                this.prepareEvaluateLayout(holder, botMessage, answer.getFaqData());
            } else {
                for (int i = 0; i < botAnswers.size(); ++i) {
                    Answer answer = botAnswers.get(i);
                    this.llContainer.addView((View)this.getListItem(i + 1, botMessage, answer));
                }
            }
        }
    }

    private boolean isSingleFaqMatched(BotMessage botMessage) {
        if (botMessage.hasBotAnswers() && botMessage.getBotAnswers().size() == 1) {
            Answer answer = botMessage.getBotAnswers().get(0);
            return answer.getType() == 1 && answer.getFaqData() != null;
        }
        return false;
    }

    private TextView getListItem(int index, BotMessage botMessage, Answer answer) {
        String answerTitle = answer.getTitle();
        Faq.FaqData faqData = answer.getFaqData();
        TextView multipleFaqItem = super.getListItem(index, answerTitle, botMessage, faqData);
        multipleFaqItem.setOnClickListener(v -> {
            if (TicketStatusTracker.isTicketServingByAnswerBot()) {
                this.sendRPAMessageWithBotAnswer(answerTitle);
            } else {
                botMessage.setUserFeedback(-1);
                this.checkoutFaqDetail(botMessage, faqData);
            }
        });
        return multipleFaqItem;
    }

    private void sendRPAMessageWithBotAnswer(String answerTitle) {
        if (this.mWrapper != null && FastClickValidator.validate()) {
            UserMessage rpaMessage = Message.getUserTextMsg(answerTitle);
            rpaMessage.setRequestParams(answerTitle, 1, 6);
            this.mWrapper.onBotAnswerSelected(rpaMessage);
            AIHelpEventTracker.getInstance().onAnswerBotSelected();
        }
    }

    private void prepareEvaluateLayout(ViewHolder holder, final BotMessage botMessage, final Faq.FaqData faq) {
        this.mEvaluateButtonView = (AIHelpEvaluateButtonView)((Object)holder.getView(this.getViewId("aihelp_evaluate_view")));
        this.mEvaluateButtonView.setMaxWidth(Styles.getScreenWidth(this.mContext) - Styles.dpToPx(this.mContext, 110.0f));
        this.mEvaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        this.mEvaluateButtonView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateButtonView.OnAIHelpEvaluateViewCallback(){

            @Override
            public void onEvaluated(boolean isHelpful) {
                botMessage.setUserFeedback(isHelpful ? 1 : 2);
            }

            @Override
            public JSONObject requestDataForFeedback() {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("mainId", faq.getMainId());
                    jsonObject.put("contentId", faq.getContentId());
                    jsonObject.put("isClickDetail", faq.isFaqViewed());
                    jsonObject.put("pointMessageId", (Object)String.valueOf(botMessage.getTimestamp()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jsonObject;
            }
        });
        this.llContainer.setMinimumWidth(this.mEvaluateButtonView.getMinWidth());
    }

    @Override
    public void onEvaluated(BotMessage botMessage, boolean isHelpful) {
        if (this.mEvaluateButtonView != null) {
            this.mEvaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        }
    }
}

