/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.cs.util.viewer.BotFaqViewer;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AgentFaqAdapter
extends BaseMsgAdapter
implements BotFaqViewer.OnFaqEvaluateListener {
    protected LinearLayout llContainer;

    public AgentFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_faq_like");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 4;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        if (message instanceof BotMessage) {
            BotMessage botMessage = (BotMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csBotSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_robot");
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), botMessage.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)botMessage.getNickname()), 13);
            this.llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_agent_faq_container"));
            this.llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
            this.llContainer.removeAllViews();
            this.llContainer.addView((View)this.getMsg(botMessage.getContent(), botMessage.isEnableInteraction()));
            if (botMessage.hasFaq()) {
                List<Faq.FaqData> faqDataList = botMessage.getFaq().getFaqDataList();
                if (faqDataList.size() == 1) {
                    Faq.FaqData faqData = faqDataList.get(0);
                    this.llContainer.addView(this.getSingleFAQItem(botMessage, faqData));
                    if (faqData.hasAttachedForm()) {
                        this.prepareFaqFormLayout(this.llContainer, faqData);
                    }
                } else {
                    for (int i = 0; i < faqDataList.size(); ++i) {
                        Faq.FaqData faqData = faqDataList.get(i);
                        this.llContainer.addView((View)this.getListItem(i + 1, faqData.getFaqTitle(), botMessage, faqData));
                    }
                }
            }
            holder.setVisible(this.getViewId("aihelp_evaluate_view"), false);
        }
    }

    protected TextView getListItem(int index, String title, BotMessage botMessage, Faq.FaqData faqData) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)String.format("%s. %s", index, title));
        textView.setTextSize(15.0f);
        textView.setClickable(true);
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(this.getFaqViewer(botMessage, faqData));
        textView.setPadding(0, this.dip2px(this.mContext, 5.0), 0, this.dip2px(this.mContext, 0.0));
        return textView;
    }

    protected View getSingleFAQItem(BotMessage botMessage, Faq.FaqData faqData) {
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        if (!TextUtils.isEmpty((CharSequence)faqData.getTemplate())) {
            TextView faqContent = new TextView(this.mContext);
            faqContent.setTextSize(15.0f);
            faqContent.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
            faqContent.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
            faqContent.setText((CharSequence)faqData.getTemplate());
            layout.addView((View)faqContent);
        }
        TextView tvShowMore = new TextView(this.mContext);
        tvShowMore.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        tvShowMore.setTextSize(15.0f);
        tvShowMore.setGravity(17);
        tvShowMore.setLineSpacing((float)this.dip2px(this.mContext, 3.0), 1.0f);
        tvShowMore.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
        tvShowMore.setPadding(0, this.dip2px(this.mContext, 7.0), 0, this.dip2px(this.mContext, 7.0));
        tvShowMore.setText((CharSequence)ResResolver.getString("aihelp_view_details"));
        tvShowMore.setOnClickListener(this.getFaqViewer(botMessage, faqData));
        tvShowMore.setVisibility(faqData.isShowMore() ? 0 : 8);
        layout.addView((View)tvShowMore);
        if (!faqData.isShowMore() && !faqData.isFaqViewed()) {
            faqData.setFaqViewed(true);
            this.trackAnswerFaqChecked(faqData);
        }
        return layout;
    }

    protected void prepareFaqFormLayout(LinearLayout container, final Faq.FaqData faqData) {
        View divider = new View(this.mContext);
        divider.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f));
        divider.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, this.dip2px(this.mContext, 1.0)));
        divider.setPadding(0, this.dip2px(this.mContext, 10.0), 0, 0);
        container.addView(divider);
        TextView tvHint = new TextView(this.mContext);
        tvHint.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, -2));
        tvHint.setPadding(0, this.dip2px(this.mContext, 10.0), 0, 0);
        Styles.reRenderTextView(tvHint, ResResolver.getString("aihelp_form_hint"));
        container.addView((View)tvHint);
        TextView formUrl = this.getHighlightedClickableTextView(faqData.getFormTitle(), new View.OnClickListener(){

            public void onClick(View v) {
                String formUrl = faqData.getFormUrl();
                if (AppInfoUtil.isUrlStillNeedResponding(AgentFaqAdapter.this.mContext, formUrl) && AgentFaqAdapter.this.mWrapper != null) {
                    AgentFaqAdapter.this.mWrapper.onUrlClicked(true, formUrl);
                }
            }
        });
        formUrl.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, -2));
        formUrl.setTypeface(Typeface.defaultFromStyle((int)1));
        formUrl.setPadding(0, this.dip2px(this.mContext, 5.0), 0, 0);
        container.addView((View)formUrl);
    }

    private View.OnClickListener getFaqViewer(BotMessage botMessage, Faq.FaqData faqData) {
        return v -> this.checkoutFaqDetail(botMessage, faqData);
    }

    protected void checkoutFaqDetail(BotMessage botMessage, Faq.FaqData faqData) {
        if (faqData != null && FastClickValidator.validate()) {
            faqData.setFaqViewed(true);
            this.trackAnswerFaqChecked(faqData);
            BotFaqViewer.INSTANCE.show(this.mContext, botMessage, faqData, this);
        }
    }

    private void trackAnswerFaqChecked(Faq.FaqData faqData) {
        String mainId = String.valueOf(faqData.getMainId());
        String contentId = String.valueOf(faqData.getContentId());
        AIHelpEventTracker.getInstance().checkedFAQInBot(faqData.getFaqSource(), mainId, contentId);
    }

    @Override
    public void onEvaluated(BotMessage botMessage, boolean isHelpful) {
    }
}

