/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AgentFileAdapter
extends BaseMsgAdapter {
    public AgentFileAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_file");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 9;
    }

    @Override
    public void convert(ViewHolder holder, final Message message, int position) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), fileMessage.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)fileMessage.getNickname()), 13);
            RelativeLayout rlContainer = (RelativeLayout)holder.getView(this.getViewId("aihelp_rl_file_container"));
            rlContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
            rlContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                    PreviewActivity.startAct(AgentFileAdapter.this.mFragment, previewInfo);
                }
            });
            TextView tvFileName = (TextView)holder.getView(this.getViewId("aihelp_tv_file_name"));
            tvFileName.setMaxWidth(this.getRightfulMaxWidthForFileName());
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_file_size")), fileMessage.getFileSize(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            Styles.reRenderImageView((ImageView)holder.getView(this.getViewId("aihelp_iv_file")), "aihelp_svg_ic_file", Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            Styles.reRenderImageView((ImageView)holder.getView(this.getViewId("aihelp_iv_download")), "aihelp_svg_ic_download", Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            holder.getView(ResResolver.getViewId("aihelp_iv_download")).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(AgentFileAdapter.this.mContext, message.getContent());
                }
            });
        }
    }

    private int getRightfulMaxWidthForFileName() {
        return Styles.getScreenWidth(this.mContext) - this.dip2px(this.mContext, 39.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 36.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 23.0) - this.dip2px(this.mContext, 60.0);
    }
}

