/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AgentImageAdapter
extends BaseMsgAdapter {
    private Fragment fragment;

    public AgentImageAdapter(Context context, Fragment fragment) {
        super(context);
        this.fragment = fragment;
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_image");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 6;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), fileMessage.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)fileMessage.getNickname()), 13);
            final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
            imageView.loadIntoImageView(this.mContext, fileMessage);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (imageView.isLoading()) {
                        return;
                    }
                    PreviewActivity.startAct(AgentImageAdapter.this.fragment, PreviewInfo.get(fileMessage.getContent()));
                }
            });
        }
    }
}

