/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AgentRichTextAdapter
extends BaseMsgAdapter {
    public AgentRichTextAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 8;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        LinearLayout llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_agent_message_container"));
        llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
        llContainer.removeAllViews();
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");
        Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), message.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)message.getNickname()), 13);
        this.convertSupportTextMsg(holder, (ViewGroup)llContainer, message);
    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, Message message) {
        holder.setVisible(this.getViewId("aihelp_tv_nickname"), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)message.getNickname()));
        holder.setText(this.getViewId("aihelp_tv_nickname"), message.getNickname());
        holder.setTextColor(this.getViewId("aihelp_tv_nickname"), Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        container.addView(this.getRichTextMsg(message.getContent(), message.isEnableInteraction()));
    }

    protected View getRichTextMsg(String msg, boolean isHistoryMessage) {
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        layout.setGravity(0x800003);
        try {
            LinkedList<Integer> urlIndexList = new LinkedList<Integer>();
            urlIndexList.add(0);
            Matcher formMatcher = Pattern.compile("(?i)(https?://\\S*?((?=\\s+http)|\\.(png|jpg|jpeg|gif|mp4|3gp|mkv|webm))|https?://((?!\").)*)").matcher(msg);
            while (formMatcher.find()) {
                urlIndexList.add(formMatcher.start());
                urlIndexList.add(formMatcher.end());
            }
            if (((Integer)urlIndexList.getLast()).intValue() != msg.length()) {
                urlIndexList.add(msg.length());
            }
            for (int i = 0; i < urlIndexList.size() - 1; ++i) {
                String urlOrRawText = msg.substring((Integer)urlIndexList.get(i), (Integer)urlIndexList.get(i + 1)).trim();
                if (Pattern.compile("\\s*?").matcher(urlOrRawText).matches()) continue;
                if (Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(urlOrRawText).matches()) {
                    layout.addView(this.getImageViewFromRichText(urlOrRawText));
                    continue;
                }
                if (Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(urlOrRawText).matches()) {
                    layout.addView(this.getVideoViewFromRichText(urlOrRawText));
                    continue;
                }
                layout.addView(this.getTextViewFromRichText(urlOrRawText, isHistoryMessage));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layout;
    }

    private View getImageViewFromRichText(final String imageUrl) {
        ImageView imageView = new ImageView(this.mContext);
        ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        layoutParams.topMargin = Styles.dpToPx(this.mContext, 3.0f);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setAdjustViewBounds(true);
        MediaUtils.scaleImageView(imageUrl, imageView, (View)imageView, null);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.startAct(AgentRichTextAdapter.this.mFragment, PreviewInfo.get(imageUrl));
            }
        });
        return imageView;
    }

    private View getVideoViewFromRichText(final String videoUrl) {
        final View rootView = View.inflate((Context)this.mContext, (int)ResResolver.getLayoutId("aihelp_loading_image_view"), null);
        final ImageView imageView = (ImageView)rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        final ImageView ivPlay = (ImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        final View maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        final View loadingView = rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        rootView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.dip2px(this.mContext, 120.0), this.dip2px(this.mContext, 150.0)));
        MediaUtils.getImageForVideo(videoUrl, new MediaUtils.OnLoadVideoImageListener(){

            @Override
            public void onLoadImage(File file) {
                MediaUtils.scaleImageView(file.getAbsolutePath(), imageView, rootView, new MediaUtils.OnImageScaledListener(){

                    @Override
                    public void onImageScaled() {
                        maskView.setVisibility(8);
                        loadingView.setVisibility(8);
                        ivPlay.setVisibility(0);
                    }
                });
                rootView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PreviewActivity.startAct(AgentRichTextAdapter.this.mFragment, PreviewInfo.get(videoUrl));
                    }
                });
            }
        });
        return rootView;
    }

    private View getTextViewFromRichText(String text, boolean isHistoryMessage) {
        TextView textView = this.getMsg(text, isHistoryMessage);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        return textView;
    }
}

