/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.ExternalUrl;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.cs.util.viewer.SelfServiceViewer;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class AgentTextAdapter
extends BaseMsgAdapter {
    public AgentTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent");
    }

    @Override
    public boolean isForViewType(Message item, int position) {
        return item.getMsgType() == 3;
    }

    @Override
    public void convert(ViewHolder holder, Message s, int position) {
        LinearLayout llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_agent_message_container"));
        llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
        llContainer.removeAllViews();
        boolean isBotAgent = s instanceof BotMessage;
        ImageView ivPortrait = (ImageView)holder.getView(this.getViewId("aihelp_iv_portrait"));
        Styles.loadIcon(ivPortrait, isBotAgent ? CustomConfig.CustomerService.csBotSupportPortrait : CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, isBotAgent ? "aihelp_svg_portrait_robot" : "aihelp_svg_portrait_agent");
        Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), s.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)s.getNickname()), 13);
        if (isBotAgent) {
            this.convertElvaBotTextMsg((ViewGroup)llContainer, (BotMessage)s);
            holder.setVisible(this.getViewId("aihelp_iv_translate"), false);
        } else {
            holder.setVisible(this.getViewId("aihelp_iv_translate"), Const.TOGGLE_TRANSLATE_CS_MESSAGE);
            this.convertSupportTextMsg(holder, (ViewGroup)llContainer, s, position);
        }
    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, Message msg, int position) {
        TextView textView = this.getMsg(msg.getContent(), msg.isEnableInteraction());
        textView.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        this.prepareTranslate(holder, textView, position);
        container.addView((View)textView);
    }

    private void convertElvaBotTextMsg(ViewGroup container, final BotMessage botMsg) {
        if (!TextUtils.isEmpty((CharSequence)botMsg.getContent())) {
            container.addView((View)this.getMsg(botMsg.getContent(), botMsg.isEnableInteraction()));
        }
        if (botMsg.hasExternalUrl()) {
            final ExternalUrl externalUrl = botMsg.getExternalUrl();
            container.addView((View)this.getHighlightedClickableTextView(externalUrl.getTitle(), new View.OnClickListener(){

                public void onClick(View v) {
                    String urlLink = externalUrl.getLink();
                    if (AppInfoUtil.isUrlStillNeedResponding(AgentTextAdapter.this.mContext, urlLink) && AgentTextAdapter.this.mWrapper != null) {
                        AgentTextAdapter.this.mWrapper.onUrlClicked(false, urlLink);
                    }
                }
            }));
        }
        if (botMsg.hasSelfService() && !botMsg.getSelfService().isEnableSend()) {
            container.addView((View)this.getHighlightedClickableTextView(ResResolver.getString("aihelp_view_details"), new View.OnClickListener(){

                public void onClick(View v) {
                    if (AgentTextAdapter.this.mWrapper != null && FastClickValidator.validate()) {
                        new SelfServiceViewer().getService(AgentTextAdapter.this.mContext, botMsg.getSelfService());
                    }
                }
            }));
        }
    }

    private void prepareTranslate(final ViewHolder holder, final TextView textView, int position) {
        if (Const.TOGGLE_TRANSLATE_CS_MESSAGE) {
            int maxTextWidth = Styles.getScreenWidth(this.mContext) - this.dip2px(this.mContext, 165.0);
            textView.setMaxWidth(maxTextWidth);
            final String originContent = textView.getText().toString();
            final StringBuilder translatedContent = new StringBuilder(originContent);
            holder.setOnClickListener(this.getViewId("aihelp_iv_translate"), new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        JSONObject params = new JSONObject();
                        params.put("deviceId", (Object)DeviceUuidFactory.id(AgentTextAdapter.this.mContext));
                        params.put("playerId", (Object)UserProfile.USER_ID);
                        params.put("content", (Object)originContent);
                        AIHelpRequest.getInstance().requestPostByJson(API.TRANSLATE_MESSAGE, params, new ReqCallback<String>(){

                            @Override
                            public void onReqSuccess(String result) {
                                translatedContent.append("\n---------\n").append(result);
                                textView.setText((CharSequence)translatedContent.toString());
                                textView.setMaxWidth(Integer.MAX_VALUE);
                            }
                        });
                        holder.setVisible(AgentTextAdapter.this.getViewId("aihelp_iv_translate"), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

