/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

public class AgentVideoAdapter
extends BaseMsgAdapter {
    private final ExecutorService mExecutorService = Executors.newCachedThreadPool();

    public AgentVideoAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_video");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 7;
    }

    @Override
    public void convert(final ViewHolder holder, Message message, final int position) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), fileMessage.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)fileMessage.getNickname()), 13);
            if (fileMessage.getVideoThumbnail() != null) {
                this.loadUpImageView(holder, fileMessage, position);
            } else if (this.mExecutorService != null) {
                this.mExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        fileMessage.prepareVideoThumbnail();
                        if (AgentVideoAdapter.this.mContext instanceof Activity && ((Activity)AgentVideoAdapter.this.mContext).isFinishing()) {
                            TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                            return;
                        }
                        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                AgentVideoAdapter.this.loadUpImageView(holder, fileMessage, position);
                            }
                        });
                    }
                });
            }
        }
    }

    private void loadUpImageView(ViewHolder holder, final FileMessage fileMessage, int position) {
        final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
        imageView.loadIntoImageView(this.mContext, fileMessage);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (imageView.isLoading()) {
                    return;
                }
                PreviewActivity.startAct(AgentVideoAdapter.this.mFragment, PreviewInfo.get(fileMessage.getContent()));
            }
        });
    }
}

