/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.mvp.IPresenter;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.widget.AIHelpChatRecyclerView;
import net.aihelp.utils.KeyboardChangeHelper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public abstract class BaseCSFragment<P extends IPresenter>
extends BaseFragment<P> {
    AIHelpChatRecyclerView rvMsgList;
    MessageListAdapter mAdapter;
    ViewGroup bottomContainer;
    EditText etInput;
    AppCompatImageButton btnSend;
    IMqttCallback mqttCallback;
    boolean isAlwaysShowSupportInElva;
    private KeyboardChangeHelper helper;
    boolean isOperateBot;
    boolean isOperateHuman;
    private Message mTimeStampMsg;
    private String titleIcon;
    private String titleText;

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        this.isOperateBot = extras.getBoolean("bot_embedded_in_operation", false);
        this.isOperateHuman = extras.getBoolean("HUMAN_embedded_in_operation", false);
        this.titleIcon = CustomConfig.CustomerService.csNavigationBarTitleIcon;
        this.titleText = CustomConfig.CustomerService.csNavigationTitle;
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new UpdateTitleEvent(1, this.titleIcon, this.titleText));
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(false));
    }

    @Override
    protected void initEventAndData(View contentView) {
        EventBus.getDefault().post(new SupportActionEvent(1002));
        this.mqttCallback = MqttCallbackImpl.getInstance();
        ViewGroup bottomRootLayout = (ViewGroup)this.get("aihelp_chat_bottom_layout");
        bottomRootLayout.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));
        this.bottomContainer = (ViewGroup)this.get("aihelp_bottom_container");
        this.rvMsgList = (AIHelpChatRecyclerView)((Object)this.get("aihelp_rv_msg_list"));
        this.rvMsgList.setBackgroundColor(0);
        this.mAdapter = new MessageListAdapter(this.getContext(), this);
        this.rvMsgList.setAdapter(this.mAdapter);
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.rvMsgList.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.helper = new KeyboardChangeHelper(this.getView());
        this.helper.addListener();
        this.helper.addOnKeyboardShowListener(new KeyboardChangeHelper.OnKeyboardShowListener(){

            @Override
            public void onKeyboardShow() {
                int firstVisibleItemPosition;
                if (!linearLayoutManager.getStackFromEnd() && (firstVisibleItemPosition = linearLayoutManager.findFirstCompletelyVisibleItemPosition()) > 0) {
                    linearLayoutManager.setStackFromEnd(true);
                }
                BaseCSFragment.this.scrollRecyclerViewToEnd();
            }

            @Override
            public void onKeyboardHide() {
                linearLayoutManager.setStackFromEnd(false);
                BaseCSFragment.this.scrollRecyclerViewToEnd();
            }
        });
    }

    protected void onTextChange(CharSequence s) {
    }

    public void updateChatList(Message msg) {
        if (msg.isEmptyMessage()) {
            return;
        }
        if (CustomConfig.CustomerService.isMessageTimestampVisible && (msg.isUserMessage() || msg.isAgentMessage())) {
            this.prepareTimeStamp(msg.getTimestamp());
        }
        if (msg.isUserMessage()) {
            this.mAdapter.update(msg);
            if (msg.isDuringRPAProcedure()) {
                this.mAdapter.updateAgentTypingStatus(true);
            }
        } else if (msg.isAgentMessage()) {
            if (msg.isDuringRPAProcedure()) {
                this.mAdapter.updateAgentTypingStatus(false);
            }
            this.mAdapter.update(msg);
        }
        this.scrollRecyclerViewToEnd();
    }

    public void updateChatList(List<Message> msgList, boolean isClear) {
        if (!ListUtil.isListEmpty(msgList)) {
            Message lastMessage;
            for (int i = msgList.size() - 1; i >= 0; --i) {
                Message msg = msgList.get(i);
                if (msg == null || !msg.isTimeStampMessage()) continue;
                this.mTimeStampMsg = msg;
                break;
            }
            if ((lastMessage = msgList.get(msgList.size() - 1)) != null && lastMessage.isAgentMessage() && lastMessage.isDuringRPAProcedure()) {
                this.mAdapter.updateAgentTypingStatus(false);
            }
        }
        this.mAdapter.update(msgList, (Boolean)isClear);
        this.scrollRecyclerViewToEnd();
    }

    protected void scrollRecyclerViewToEnd() {
        this.rvMsgList.post(new Runnable(){

            @Override
            public void run() {
                BaseCSFragment.this.rvMsgList.scrollToPosition(BaseCSFragment.this.mAdapter.getItemCount() - 1);
            }
        });
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.rvMsgList != null) {
            SoftInputUtil.hideSoftInput(this.getContext(), (View)this.rvMsgList);
            this.rvMsgList.setBackgroundColor(0);
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.helper != null) {
            this.helper.removeListener();
        }
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    private void prepareTimeStamp(long timeStamp) {
        if (this.mTimeStampMsg == null || timeStamp - Long.parseLong(this.mTimeStampMsg.getContent()) > 300000L) {
            this.mTimeStampMsg = new Message(1);
            this.mTimeStampMsg.setTimestamp(timeStamp - 1L);
            this.mTimeStampMsg.setContent(String.valueOf(timeStamp));
            this.mAdapter.update(this.mTimeStampMsg);
        }
    }
}

