/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.monitor.NetworkMonitor;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.attachment.AttachmentPicker;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.logic.CustomerServicePresenter;
import net.aihelp.data.logic.MessagePoller;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomActionPickerView;
import net.aihelp.ui.cs.bottom.BottomAttachmentView;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.ui.cs.bottom.BottomBotInputView;
import net.aihelp.ui.cs.bottom.BottomDatePickerView;
import net.aihelp.ui.cs.bottom.BottomEvaluateFaqView;
import net.aihelp.ui.cs.bottom.BottomEvaluateServiceView;
import net.aihelp.ui.cs.bottom.BottomFillFormView;
import net.aihelp.ui.cs.bottom.BottomManualInputView;
import net.aihelp.ui.cs.bottom.BottomNewConversationView;
import net.aihelp.ui.cs.bottom.BottomSelfServiceView;
import net.aihelp.ui.cs.middle.MiddleHandlerView;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.cs.util.rpa.factory.UserMessageFactory;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

public class CustomerServiceFragment
extends BaseCSFragment<CustomerServicePresenter>
implements IServiceEventListener {
    private boolean shouldRefreshSkipView;
    private boolean isTicketAlreadyFinished;
    private SwipeRefreshLayout mRefreshLayout;
    private RPAStep mCurrentStep;
    private MiddleHandlerView mHandlerView;
    private BottomBaseView bottomBaseView = null;

    public static CustomerServiceFragment newInstance(Bundle bundle) {
        CustomerServiceFragment customerServiceFragment = new CustomerServiceFragment();
        customerServiceFragment.setArguments(bundle);
        return customerServiceFragment;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.shouldRefreshSkipView) {
            this.scrollRecyclerViewToEnd();
            this.mHandlerView.updateViewVisibility(this.mCurrentStep);
        }
    }

    @Override
    protected void initEventAndData(View contentView) {
        super.initEventAndData(contentView);
        this.mHandlerView = (MiddleHandlerView)this.get("aihelp_middle_view");
        this.mHandlerView.setServiceEventListener(this);
        this.mRefreshLayout = (SwipeRefreshLayout)this.get("aihelp_refresh_layout");
        this.mRefreshLayout.setEnabled(CustomConfig.CustomerService.isHistoryChatEnable);
        this.mRefreshLayout.setColorSchemeColors(new int[]{Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor)});
        if (CustomConfig.CustomerService.isHistoryChatEnable) {
            this.mRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    ((CustomerServicePresenter)CustomerServiceFragment.this.mPresenter).getLastConversation();
                }
            });
        }
        this.mAdapter.setOnClickedListener(new MessageListAdapter.OnClickedListenerWrapper(){

            @Override
            public void onUrlClicked(boolean isForm, String url) {
                super.onUrlClicked(isForm, url);
                Bundle bundle = new Bundle();
                bundle.putString("intent_url", url);
                EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
            }

            @Override
            public void onBotAnswerSelected(Message message) {
                CustomerServiceFragment.this.onUserAction(message);
            }

            @Override
            public void onRetrySendingMessage(int position, Message msg) {
                if (!AppInfoUtil.validateNetwork(CustomerServiceFragment.this.getContext())) {
                    return;
                }
                if (CustomerServiceFragment.this.isTicketAlreadyFinished) {
                    ToastUtil.INSTANCE.makeRawToast(CustomerServiceFragment.this.getContext(), ResResolver.getString("aihelp_ticket_closed"));
                    return;
                }
                if (msg.getMsgStatus() != 3) {
                    CustomerServiceFragment.this.mAdapter.remove(position);
                }
                CustomerServiceFragment.this.onUserAction(msg);
            }
        });
        this.mqttCallback.showMqttLoading();
        ((CustomerServicePresenter)this.mPresenter).requestLogin();
        ((CustomerServicePresenter)this.mPresenter).refreshUnreadMessageCount();
    }

    public void prepareMqtt(int connectionType) {
        this.mqttCallback.updateHostView(this);
        ((CustomerServicePresenter)this.mPresenter).prepareMqtt(this.mqttCallback, connectionType);
    }

    public void onLogin(List<Message> msgList, Message message, RPAStep rpaStep) {
        this.updateChatList(msgList, true);
        this.updateBottomLayout(message, rpaStep);
        MessagePoller.INSTANCE.startMessagePolling(this);
        this.prepareMqtt(1);
    }

    public void onFormSubmitted(String formContent) {
        this.shouldRefreshSkipView = true;
        this.updateChatList(UserMessageFactory.getUserFormMsgList(formContent), false);
        if (!TicketStatusTracker.isTicketActive && !(this.bottomContainer.getChildAt(0) instanceof BottomManualInputView)) {
            RPAStep rpaStep = new RPAStep();
            rpaStep.setNextStep(100);
            this.updateBottomLayout(new Message(), rpaStep);
        }
    }

    public void onLastConversationRetrieved(List<Message> msgList) {
        this.mRefreshLayout.setRefreshing(false);
        if (!ListUtil.isListEmpty(msgList)) {
            this.mAdapter.insertHistoryConversation(msgList);
            RecyclerView.LayoutManager layoutManager = this.rvMsgList.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                LinearLayoutManager linearManager = (LinearLayoutManager)layoutManager;
                int lastItemPosition = linearManager.findLastVisibleItemPosition();
                this.rvMsgList.scrollToPosition(msgList.size() - 1 + lastItemPosition);
                this.rvMsgList.smoothScrollBy(0, -100);
            }
        }
    }

    public void onTicketFinishedOrRejected() {
        this.isTicketAlreadyFinished = true;
        RPAStep rpaStep = new RPAStep();
        if (TicketStatusTracker.isTicketFinished) {
            if (TicketStatusTracker.isTicketWaitForAskingResolveStatus || TicketStatusTracker.isTicketWaitForRating) {
                rpaStep.setNextStep(101);
            } else {
                rpaStep.setNextStep(102);
            }
        } else if (TicketStatusTracker.isTicketRejected) {
            rpaStep.setNextStep(102);
        }
        this.updateBottomLayout(new Message(), rpaStep);
        this.mHandlerView.setVisibility(8);
        this.mAdapter.updateAgentTypingStatus(false);
    }

    public void onTicketAssignStatusChanged() {
        this.shouldRefreshSkipView = true;
        this.mHandlerView.updateViewVisibility(null);
    }

    @Override
    public void onUserAction(Message message) {
        this.mHandlerView.setVisibility(8);
        if (message instanceof FileMessage) {
            if (message.getMsgStatus() == 2) {
                this.updateChatList(message);
            } else {
                this.updateMessageStatus(message.getMsgStatus() == 1, message.getTimestamp(), message.getTimestamp());
            }
        } else {
            this.updateChatList(message);
        }
        if (message.getMsgStatus() == 1) {
            ((CustomerServicePresenter)this.mPresenter).chatWithSupport(message.getTimestamp(), message.getRequestParams());
        }
        if (message.isDuringRPAProcedure()) {
            this.bottomContainer.removeAllViews();
        }
    }

    @Override
    public void onUserGoBack() {
        this.mHandlerView.setVisibility(8);
        this.bottomContainer.removeAllViews();
        ((CustomerServicePresenter)this.mPresenter).goBackToPreviousStep();
    }

    @Override
    public void onTicketFinished(int nextStep) {
        this.isTicketAlreadyFinished = true;
        RPAStep rpaStep = new RPAStep();
        rpaStep.setNextStep(nextStep);
        this.updateBottomLayout(new Message(), rpaStep);
    }

    @Override
    public void onNewConversationStarted() {
        this.isTicketAlreadyFinished = false;
        ((CustomerServicePresenter)this.mPresenter).logout();
        ((CustomerServicePresenter)this.mPresenter).requestLogin();
    }

    public void updateMessageStatus(boolean updateToNormal, long timestamp, long updatedTimestamp) {
        for (int i = this.mAdapter.getDataList().size() - 1; i >= 0; --i) {
            Message msg = (Message)this.mAdapter.getDataList().get(i);
            if (msg.getTimestamp() != timestamp) continue;
            msg.setTimestamp(updatedTimestamp);
            msg.setMsgStatus(updateToNormal ? 1 : 3);
            this.mAdapter.notifyItemChanged(i);
            if (updateToNormal) break;
            this.mAdapter.updateAgentTypingStatus(false);
            break;
        }
    }

    public void notifyMessageWithdrawn(long startTime, long endTime) {
        for (int i = this.mAdapter.getDataList().size() - 1; i >= 0; --i) {
            Message msg = (Message)this.mAdapter.getDataList().get(i);
            if (msg.getTimestamp() < startTime || msg.getTimestamp() > endTime) continue;
            this.mAdapter.remove(i);
            ((CustomerServicePresenter)this.mPresenter).updateCachedUnreadMessageCount(msg.isAgentMessage(), true);
            if (startTime == endTime) break;
        }
    }

    public void notifyMessageWithdrawn(long withdrawTimeStamp) {
        this.notifyMessageWithdrawn(withdrawTimeStamp, withdrawTimeStamp);
    }

    @Override
    public void updateChatList(Message msg) {
        super.updateChatList(msg);
        this.updateCacheUnreadMessageCount(msg);
    }

    @Override
    public void updateChatList(List<Message> msgList, boolean isClear) {
        super.updateChatList(msgList, isClear);
        if (!isClear) {
            for (int i = 0; i < msgList.size(); ++i) {
                this.updateCacheUnreadMessageCount(msgList.get(i));
            }
        }
    }

    private void updateCacheUnreadMessageCount(Message message) {
        if (message != null) {
            ((CustomerServicePresenter)this.mPresenter).updateCachedUnreadMessageCount(message.isAgentMessage(), false);
        }
    }

    @Override
    @NetworkMonitor
    public void onNetworkStateChanged(NetworkState networkState) {
        if (networkState != NetworkState.NONE && !MqttConfig.getInstance().isConnected()) {
            AIHelpMqtt.getInstance().prepare(this.mqttCallback, 2);
        }
    }

    public void updateBottomLayout(Message message, RPAStep rpaStep) {
        this.updateBottomLayout(message, rpaStep, true);
    }

    public void updateBottomLayout(Message message, RPAStep rpaStep, boolean scrollToEnd) {
        this.mHandlerView.updateViewVisibility(rpaStep);
        this.mCurrentStep = rpaStep;
        this.bottomBaseView = null;
        Bundle bundle = new Bundle();
        switch (rpaStep.getNextStep()) {
            case 1: 
            case 2: 
            case 3: {
                this.bottomBaseView = new BottomBotInputView(this.getContext());
                break;
            }
            case 4: {
                this.bottomBaseView = new BottomActionPickerView(this.getContext());
                break;
            }
            case 5: {
                this.bottomBaseView = new BottomDatePickerView(this.getContext());
                break;
            }
            case 6: {
                this.bottomBaseView = new BottomAttachmentView(this.getContext());
                break;
            }
            case 7: {
                if (message instanceof BotMessage && ((BotMessage)message).hasFormUrl()) {
                    bundle.putString("intent_url", ((BotMessage)message).getFormUrl().getLink());
                    this.bottomBaseView = new BottomFillFormView(this.getContext());
                    break;
                }
                this.bottomBaseView = new BottomBotInputView(this.getContext());
                break;
            }
            case 8: {
                if (message instanceof BotMessage && ((BotMessage)message).hasSelfService()) {
                    bundle.putParcelable("bottom_self_service", (Parcelable)((BotMessage)message).getSelfService());
                    this.bottomBaseView = new BottomSelfServiceView(this.getContext());
                    break;
                }
                this.bottomBaseView = new BottomBotInputView(this.getContext());
                break;
            }
            case 9: {
                List<Faq.FaqData> faqDataList;
                if (message instanceof BotMessage && ((BotMessage)message).hasFaq() && (faqDataList = ((BotMessage)message).getFaq().getFaqDataList()) != null && faqDataList.size() == 1) {
                    bundle.putLong("bottom_faq_content_id", faqDataList.get(0).getContentId());
                }
                this.bottomBaseView = new BottomEvaluateFaqView(this.getContext());
                break;
            }
            case 100: {
                bundle.putBoolean("bottom_ticket_finished", this.isTicketAlreadyFinished);
                bundle.putBoolean("bottom_during_procedure", false);
                this.bottomBaseView = new BottomManualInputView(this.getContext());
                break;
            }
            case 101: {
                this.bottomBaseView = new BottomEvaluateServiceView(this.getContext());
                break;
            }
            case 102: {
                this.bottomBaseView = new BottomNewConversationView(this.getContext());
            }
        }
        if (this.bottomBaseView != null && !this.isBottomViewAlreadyAdded(this.bottomBaseView, bundle, rpaStep)) {
            if (TicketStatusTracker.isTicketServingByRPA() || TicketStatusTracker.isTicketServingByAgent()) {
                this.mAdapter.updateAgentTypingStatus(false);
            }
            this.bottomBaseView.setBottomViewEventListener(bundle, rpaStep, this);
            this.bottomBaseView.setActivity(this.getActivity());
            this.bottomContainer.removeAllViews();
            this.bottomContainer.addView((View)this.bottomBaseView);
        }
        if (scrollToEnd) {
            this.scrollRecyclerViewToEnd();
        }
    }

    private boolean isBottomViewAlreadyAdded(BottomBaseView baseView, Bundle bundle, RPAStep rpaStep) {
        if (baseView != null) {
            String currentBottomViewName;
            String targetBottomViewName = baseView.getClass().getSimpleName();
            BottomBaseView currentBottomView = (BottomBaseView)this.bottomContainer.getChildAt(0);
            if (currentBottomView != null && targetBottomViewName.equals(currentBottomViewName = currentBottomView.getClass().getSimpleName())) {
                currentBottomView.setBottomViewEventListener(bundle, rpaStep, this);
                this.bottomBaseView = currentBottomView;
                return true;
            }
        }
        return false;
    }

    public long getLastAgentMessageTimestamp() {
        List dataList = this.mAdapter.getDataList();
        for (int i = dataList.size() - 1; i >= 0; --i) {
            Message message = (Message)dataList.get(i);
            if (!message.isAgentMessage()) continue;
            return message.getTimestamp();
        }
        return System.currentTimeMillis();
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_customer_service");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_customer_service_root");
    }

    @Override
    public Fragment getHostFragment() {
        return this;
    }

    @Override
    public void scrollToBottom() {
        this.scrollRecyclerViewToEnd();
    }

    @Override
    public void scrollBy(int height) {
        this.rvMsgList.scrollBy(0, height);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            ((CustomerServicePresenter)this.mPresenter).logout();
        }
        AIHelpMqtt.getInstance().disconnect();
        MessagePoller.INSTANCE.stopMessagePolling();
        AIHelpEventTracker.getInstance().calculateDurationInCustomerService();
    }

    @Override
    public void onMiddleHandlerViewVisibilityChanged() {
        boolean middleViewVisible = this.mHandlerView != null && this.mHandlerView.isVisible();
        int targetMarginBottom = Styles.dpToPx(this.getContext(), middleViewVisible ? 45.0f : 0.0f);
        ViewGroup.LayoutParams layoutParams = this.mRefreshLayout.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)layoutParams;
            if (params.bottomMargin != targetMarginBottom) {
                params.bottomMargin = targetMarginBottom;
                this.mRefreshLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                this.scrollRecyclerViewToEnd();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(permissions, grantResults);
    }

    @Permission(requestCode=1000)
    public void onPermissionRequested(Permission.Result result, final IPermissionCallback callback, int requestType) {
        switch (result) {
            case GRANTED: 
            case NONE: {
                AttachmentPicker.INSTANCE.setPickerHost(this).setAttachmentPickerListener(this.bottomBaseView).launchPicker(requestType);
                break;
            }
            case DENIED: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), 0);
                break;
            }
            case RATIONAL: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), ResResolver.getString("aihelp_yes"), 0, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionRational();
                    }
                });
                break;
            }
            case GO_SETTING: {
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_ignored"), ResResolver.getString("aihelp_permission_settings"), 0, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionIgnored();
                    }
                });
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        AttachmentPicker.INSTANCE.onAttachmentRequestResult(requestCode, resultCode, intent);
    }
}

