/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.attachment.AttachmentHelper;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

public class IntentUrlFragment
extends BaseFragment {
    private AIHelpWebView mWebView;
    private AIHelpWebChromeClient mClient;

    public static IntentUrlFragment newInstance(Bundle bundle) {
        IntentUrlFragment formFragment = new IntentUrlFragment();
        formFragment.setArguments(bundle);
        return formFragment;
    }

    @Override
    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface"})
    protected void initEventAndData(View view) {
        AIHelpWebProgress progressBar = (AIHelpWebProgress)((Object)this.get("aihelp_progress_bar"));
        this.mClient = new AIHelpWebChromeClient(this, progressBar);
        this.mWebView = (AIHelpWebView)((Object)this.get("aihelp_web_view"));
        this.mWebView.setBackgroundColor(0);
        this.mWebView.setWebViewClient(new AIHelpWebViewClient(this.getContext(), progressBar));
        this.mWebView.setWebChromeClient(this.mClient);
        if (this.getActivity() != null && this.mWebView != null) {
            this.mWebView.addJavascriptInterface(this.getActivity(), "android");
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String intentUrl = extras.getString("intent_url");
        if (this.mWebView != null) {
            this.mWebView.loadUrl(DomainSupportHelper.getAdjustedUrl(intentUrl));
        }
        TLog.d("Intent URL is " + DomainSupportHelper.getAdjustedUrl(intentUrl));
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new SupportActionEvent(1002));
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_intent_url");
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mClient != null) {
            this.mClient.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean onBackPressed() {
        if (this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return false;
        }
        return true;
    }

    @Permission(requestCode=1001)
    public void onPermissionRequested(Permission.Result result, final IPermissionCallback callback, int requestType) {
        switch (result) {
            case GRANTED: 
            case NONE: {
                this.startActivityForResult(AttachmentHelper.getIntentForMedia(requestType), 1);
                break;
            }
            case DENIED: {
                if (this.mClient != null) {
                    this.mClient.cancelChooseFileDialog();
                }
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), -1);
                break;
            }
            case RATIONAL: {
                if (this.mClient != null) {
                    this.mClient.cancelChooseFileDialog();
                }
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_denied"), ResResolver.getString("aihelp_yes"), -2, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionRational();
                    }
                });
                break;
            }
            case GO_SETTING: {
                if (this.mClient != null) {
                    this.mClient.cancelChooseFileDialog();
                }
                ToastUtil.INSTANCE.showRawSnackBar((Activity)this.getActivity(), ResResolver.getString("aihelp_permission_ignored"), ResResolver.getString("aihelp_permission_settings"), -1, new View.OnClickListener(){

                    public void onClick(View v) {
                        callback.onPermissionIgnored();
                    }
                });
                break;
            }
            default: {
                if (this.mClient == null) break;
                this.mClient.cancelChooseFileDialog();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(permissions, grantResults);
    }
}

