/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.luban.Luban;
import net.aihelp.core.util.luban.OnCompressListener;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.data.attachment.AttachmentPicker;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.UploadFileHelper;
import org.json.JSONObject;

public class BottomAttachmentView
extends BottomBaseView
implements View.OnClickListener,
IAttachmentPickerListener {
    public BottomAttachmentView(Context context) {
        this(context, null);
    }

    public BottomAttachmentView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomAttachmentView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_attachment"), (ViewGroup)this);
        AIHelpButton addAttachment = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_btn_add_attachment"));
        addAttachment.setText(ResResolver.getString("aihelp_upload_attachment"));
        addAttachment.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        Fragment hostFragment;
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_add_attachment") && this.mListener != null && (hostFragment = this.mListener.getHostFragment()) != null) {
            String[] permissionArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
            if (Build.VERSION.SDK_INT >= 33) {
                permissionArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
            }
            AIHelpPermissions.getInstance().setHost(hostFragment).setRequestCode(1000).setRequestPermission(permissionArray).request(this.getContext(), 3);
        }
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        super.setBottomViewEventListener(bundle, step, listener);
        if (step != null) {
            CustomConfig.UploadLimit.rpaAttachmentTypes = step.getAttachmentTypes();
        }
    }

    @Override
    public void onPickSuccess(File pickedFile) {
        Fragment hostFragment;
        String path = pickedFile.getAbsolutePath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            ToastUtil.INSTANCE.makeText(this.getContext(), "Failed to get file path", false);
            return;
        }
        if (this.mListener != null && (hostFragment = this.mListener.getHostFragment()) != null) {
            PreviewInfo previewInfo = PreviewInfo.get(path, pickedFile.getName(), pickedFile.length(), true);
            PreviewActivity.startAct(hostFragment, previewInfo);
        }
    }

    @Override
    public void onPickFailure(int errCode) {
        ToastUtil.INSTANCE.makeRawToast(this.getContext(), ResResolver.getString("aihelp_resource_not_support"));
    }

    @Override
    public void onPreviewCanceled(int attachmentType) {
        Fragment hostFragment;
        if (this.mListener != null && (hostFragment = this.mListener.getHostFragment()) != null) {
            AttachmentPicker.INSTANCE.setPickerHost(hostFragment).setAttachmentPickerListener(this).launchPicker(attachmentType);
        }
    }

    @Override
    public void onPreviewConfirmed(String path) {
        if (CustomConfig.UploadLimit.isImageEnableUploading && Pattern.compile("(?i).+\\.(png|jpg|jpeg|gif)$").matcher(path).matches()) {
            if (path.endsWith(".gif") || path.endsWith(".GIF")) {
                this.uploadFile(11, new File(path));
            } else {
                this.compressImage(path);
            }
        } else if (CustomConfig.UploadLimit.isVideoEnableUploading && Pattern.compile("(?i).+\\.(mp4|3gp|mkv|webm)$").matcher(path).matches()) {
            this.uploadFile(12, new File(path));
        } else if (CustomConfig.UploadLimit.isFileEnableUploading) {
            this.uploadFile(14, new File(path));
        } else {
            ToastUtil.INSTANCE.makeRawToast(this.getContext(), ResResolver.getString("aihelp_resource_not_support"));
        }
    }

    private void compressImage(final String path) {
        Luban.with(this.getContext()).load(path).setCompressListener(new OnCompressListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onSuccess(File compressedFile) {
                BottomAttachmentView.this.uploadFile(11, compressedFile);
            }

            @Override
            public void onError(Throwable e) {
                BottomAttachmentView.this.uploadFile(11, new File(path));
            }
        }).launch();
    }

    public void uploadFile(final int msgType, final File file) {
        if (this.mListener != null && file != null) {
            final FileMessage fileMsg = new FileMessage(msgType, file.getPath());
            fileMsg.setFileInfo(file.getName(), file.length());
            fileMsg.setMsgStatus(2);
            fileMsg.setDuringRPAProcedure(this.bundle.getBoolean("bottom_during_procedure", true));
            this.mListener.onUserAction(fileMsg);
            UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener(){

                @Override
                public void onFileUploaded(String fileUrl) {
                    boolean isUrlValid = !TextUtils.isEmpty((CharSequence)fileUrl);
                    fileMsg.setMsgStatus(isUrlValid ? 1 : 3);
                    fileMsg.setDuringRPAProcedure(BottomAttachmentView.this.bundle.getBoolean("bottom_during_procedure", true));
                    fileMsg.setRequestParams(BottomAttachmentView.this.getUploadRequestParams(msgType, fileUrl, file));
                    if (BottomAttachmentView.this.mListener != null) {
                        BottomAttachmentView.this.mListener.onUserAction(fileMsg);
                    }
                }
            }).performUpload(file);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        UploadFileHelper.INSTANCE.setOnUploadFileListener(null);
    }

    private JSONObject getUploadRequestParams(int msgType, String fileUrl, File file) {
        switch (msgType) {
            case 11: {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getPath());
                return UserMessage.getRequestParams(fileUrl, file.getName(), file.length(), this.getSafeValue(bitmap, "getWidth", 0).intValue(), (float)this.getSafeValue(bitmap, "getHeight", 0).intValue());
            }
            case 12: {
                Bitmap thumbnail = BitmapFactory.decodeFile((String)MediaUtils.getImageForVideoSync(file.getPath()));
                return UserMessage.getRequestParams(fileUrl, file.getName(), file.length(), this.getSafeValue(thumbnail, "getWidth", 0).intValue(), (float)this.getSafeValue(thumbnail, "getHeight", 0).intValue());
            }
            case 14: {
                return UserMessage.getRequestParams(fileUrl, file.getName(), file.length(), 0.0f, 0.0f);
            }
        }
        return null;
    }

    private <In, Out> Out getSafeValue(In value, String methodName, Out fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            Class<?> clazz = value.getClass();
            Method declaredMethod = clazz.getDeclaredMethod(methodName, new Class[0]);
            declaredMethod.setAccessible(true);
            return (Out)declaredMethod.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            return fallback;
        }
    }
}

