/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import java.io.File;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.event.HideAttachmentMenuEvent;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.cs.bottom.BottomAttachmentView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.KeyboardChangeHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class BottomManualInputView
extends BottomAttachmentView
implements View.OnClickListener,
IAttachmentPickerListener {
    private final ImageView ivAttach;
    private final View vToolsLayout;
    private final LinearLayout llToolContainer;

    public BottomManualInputView(Context context) {
        super(context);
        this.removeAllViews();
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_input_for_manual"), (ViewGroup)this);
        this.ivAttach = (ImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_attach"));
        this.ivAttach.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(this.ivAttach, "aihelp_svg_ic_add_attachment", true);
        this.vToolsLayout = this.findViewById(ResResolver.getViewId("aihelp_rl_tool"));
        View vDivider = this.findViewById(ResResolver.getViewId("aihelp_v_divider"));
        int upperBackgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        int iconBgColor = Styles.getColorWithAlpha(Styles.isLightColor(upperBackgroundColor) ? -16777216 : -1, 0.1);
        vDivider.setBackgroundColor(iconBgColor);
        this.llToolContainer = (LinearLayout)this.findViewById(ResResolver.getViewId("aihelp_ll_tool_item"));
        if (CustomConfig.UploadLimit.isImageEnableUploading || CustomConfig.UploadLimit.isVideoEnableUploading) {
            this.llToolContainer.addView(this.getToolItemView(1));
        }
        if (CustomConfig.UploadLimit.isFileEnableUploading) {
            this.llToolContainer.addView(this.getToolItemView(2));
        }
        this.prepareInputView();
        boolean enableAttach = CustomConfig.UploadLimit.isImageEnableUploading || CustomConfig.UploadLimit.isVideoEnableUploading || CustomConfig.UploadLimit.isFileEnableUploading;
        this.ivAttach.setVisibility(enableAttach ? 0 : 8);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.etInput.getLayoutParams();
        layoutParams.leftMargin = Styles.dpToPx(context, enableAttach ? 0.0f : 15.0f);
        this.etInput.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send") && this.mListener != null) {
            String input = this.etInput.getText().toString().trim();
            UserMessage userMessage = Message.getUserTextMsg(input);
            userMessage.setDuringRPAProcedure(false);
            userMessage.setRequestParams(input, 1, 1);
            this.mListener.onUserAction(userMessage);
            this.etInput.setText((CharSequence)"");
        }
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_iv_attach")) {
            if (this.vToolsLayout.getHeight() == 0) {
                SoftInputUtil.hideSoftInput(this.getContext(), (View)this);
                this.toggleToolMenu(true);
            } else {
                this.etInput.requestFocus();
                SoftInputUtil.showSoftInput(this.getContext());
                this.toggleToolMenu(false);
            }
        }
    }

    private void toggleToolMenu(final boolean show) {
        int[] nArray;
        if (show) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = Styles.dpToPx(this.getContext(), 118.0f);
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = Styles.dpToPx(this.getContext(), 118.0f);
            nArray = nArray3;
            nArray3[1] = 0;
        }
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])nArray);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                if (BottomManualInputView.this.mListener != null) {
                    BottomManualInputView.this.mListener.scrollBy(value);
                }
                ViewGroup.LayoutParams layoutParams = BottomManualInputView.this.vToolsLayout.getLayoutParams();
                layoutParams.height = value;
                BottomManualInputView.this.vToolsLayout.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!KeyboardChangeHelper.isKeyboardShown((View)BottomManualInputView.this)) {
                    BottomManualInputView.this.etInput.clearFocus();
                }
                if (show && BottomManualInputView.this.mListener != null) {
                    BottomManualInputView.this.mListener.scrollToBottom();
                }
            }
        });
        valueAnimator.setDuration(250L);
        valueAnimator.start();
    }

    @Override
    public void onPickSuccess(File pickedFile) {
        if (this.bundle != null && this.bundle.getBoolean("bottom_ticket_finished")) {
            return;
        }
        super.onPickSuccess(pickedFile);
    }

    private View getToolItemView(final int attachmentType) {
        String iconResource = "";
        String toolName = "";
        int imgWidth = 0;
        int imgHeight = 0;
        switch (attachmentType) {
            case 1: {
                iconResource = "aihelp_svg_ic_image";
                toolName = ResResolver.getString("aihelp_albums");
                imgWidth = Styles.dpToPx(this.getContext(), 30.0f);
                imgHeight = Styles.dpToPx(this.getContext(), 25.0f);
                break;
            }
            case 2: {
                iconResource = "aihelp_svg_ic_file";
                toolName = ResResolver.getString("aihelp_file");
                imgWidth = Styles.dpToPx(this.getContext(), 25.0f);
                imgHeight = Styles.dpToPx(this.getContext(), 30.0f);
            }
        }
        View itemView = View.inflate((Context)this.getContext(), (int)ResResolver.getLayoutId("aihelp_tool_item_view"), null);
        itemView.setBackground((Drawable)Styles.getClickableDrawableForList());
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Fragment hostFragment;
                if (BottomManualInputView.this.mListener != null && (hostFragment = BottomManualInputView.this.mListener.getHostFragment()) != null) {
                    String[] permissionArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
                    if (Build.VERSION.SDK_INT >= 33) {
                        permissionArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
                    }
                    AIHelpPermissions.getInstance().setHost(hostFragment).setRequestCode(1000).setRequestPermission(permissionArray).request(BottomManualInputView.this.getContext(), attachmentType);
                }
            }
        });
        LinearLayout iconContainer = (LinearLayout)itemView.findViewById(ResResolver.getViewId("aihelp_ll_icon_container"));
        int upperBackgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        int iconBgColor = Styles.getColorWithAlpha(Styles.isLightColor(upperBackgroundColor) ? -16777216 : -1, 0.1);
        iconContainer.setBackground(Styles.getDrawable(iconBgColor, 10));
        ImageView ivIcon = (ImageView)itemView.findViewById(ResResolver.getViewId("aihelp_iv_tool_icon"));
        ivIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(imgWidth, imgHeight));
        Styles.reRenderImageView(ivIcon, iconResource);
        TextView tvTitle = (TextView)itemView.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, toolName);
        tvTitle.setTextSize(2, 13.0f);
        return itemView;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof HideAttachmentMenuEvent && this.vToolsLayout.getHeight() != 0) {
            this.toggleToolMenu(false);
        }
    }
}

