/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.middle;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.config.IntentEntity;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.middle.intent.IOnIntentViewEventListener;
import net.aihelp.ui.cs.middle.intent.SmartIntentView;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class MiddleHandlerView
extends RelativeLayout
implements View.OnClickListener,
IOnIntentViewEventListener {
    private final SmartIntentView intentView;
    private final AIHelpButton tvPrevStep;
    private final AIHelpButton tvSkip;
    private IServiceEventListener serviceEventListener;

    public void setServiceEventListener(IServiceEventListener serviceEventListener) {
        this.serviceEventListener = serviceEventListener;
    }

    public MiddleHandlerView(Context context) {
        this(context, null);
    }

    public MiddleHandlerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MiddleHandlerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_middle_handler"), (ViewGroup)this);
        this.intentView = (SmartIntentView)this.findViewById(ResResolver.getViewId("aihelp_smart_intent"));
        this.tvPrevStep = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_tv_previous"));
        this.tvSkip = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_tv_skip"));
        this.tvPrevStep.setOnClickListener(this);
        this.tvSkip.setOnClickListener(this);
        this.intentView.setOnIntentViewEventListener(this);
    }

    public void onClick(View v) {
        if (!AppInfoUtil.validateNetwork(this.getContext())) {
            return;
        }
        if (v.getId() == ResResolver.getViewId("aihelp_tv_previous") && this.serviceEventListener != null) {
            this.serviceEventListener.onUserGoBack();
        }
        if (v.getId() == ResResolver.getViewId("aihelp_tv_skip") && this.serviceEventListener != null) {
            String skip = this.tvSkip.getText().toString();
            UserMessage userMessage = Message.getUserTextMsg(skip);
            userMessage.setRequestParams(skip, true, 2, "", 7);
            this.serviceEventListener.onUserAction(userMessage);
            this.tvSkip.setVisibility(8);
            this.notifyVisibilityChanged();
        }
    }

    public void updateViewVisibility(RPAStep rpaStep) {
        this.setVisibility(0);
        if (rpaStep != null && rpaStep.isEnableSkip() && rpaStep.getNextStep() != 4) {
            this.updateButtonStyle(this.tvSkip, rpaStep.getSkipHint());
        }
        if (rpaStep != null && rpaStep.isEnablePrevStep()) {
            this.updateButtonStyle(this.tvPrevStep, rpaStep.getPrevStepHint());
        } else {
            this.intentView.updateViewVisibility();
        }
        this.notifyVisibilityChanged();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.tvSkip.setVisibility(8);
        this.tvPrevStep.setVisibility(8);
        this.intentView.setVisibility(8);
        if (visibility != this.getVisibility()) {
            this.notifyVisibilityChanged();
        }
    }

    public void notifyVisibilityChanged() {
        if (this.serviceEventListener != null) {
            this.serviceEventListener.onMiddleHandlerViewVisibilityChanged();
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0 && (this.intentView.getVisibility() == 0 || this.tvPrevStep.getVisibility() == 0 || this.tvSkip.getVisibility() == 0);
    }

    @Override
    public void onIntentViewVisibilityChanged(int visibility) {
        this.notifyVisibilityChanged();
    }

    @Override
    public void onIntentSelected(IntentEntity intent) {
        String intentName = intent.getIntentName();
        String intentId = String.valueOf(intent.getIntentId());
        UserMessage userMessage = Message.getUserTextMsg(intentName);
        userMessage.setRequestParams(intentName, false, 5, intentId, 8);
        if (this.serviceEventListener != null) {
            this.serviceEventListener.onUserAction(userMessage);
        }
    }

    private void updateButtonStyle(AIHelpButton targetView, String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            targetView.setVisibility(0);
            targetView.setMaxWidth(Styles.getScreenWidth(this.getContext()) / 4);
            targetView.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
            targetView.setText(text);
        } else {
            targetView.setVisibility(8);
        }
    }
}

