/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.middle.intent;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.model.config.IntentEntity;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.adapter.SmartIntentAdapter;
import net.aihelp.ui.cs.middle.intent.IOnIntentViewEventListener;
import net.aihelp.ui.cs.middle.intent.SmartIntentScrollView;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class SmartIntentView
extends LinearLayout
implements View.OnClickListener,
SmartIntentAdapter.OnIntentSelectedListener {
    private ProcessEntity currentProcess;
    private final SmartIntentScrollView svIntent;
    private final AIHelpButton tvIntent;
    private final SmartIntentAdapter subIntentAdapter;
    private IOnIntentViewEventListener intentViewEventListener;

    public void setOnIntentViewEventListener(IOnIntentViewEventListener intentViewEventListener) {
        this.intentViewEventListener = intentViewEventListener;
    }

    public SmartIntentView(Context context) {
        this(context, null);
    }

    public SmartIntentView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartIntentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_smart_intent_view"), (ViewGroup)this);
        this.svIntent = (SmartIntentScrollView)this.findViewById(ResResolver.getViewId("aihelp_intent_scroll"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        this.svIntent.setBackgroundColor(backgroundColor);
        this.tvIntent = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_tv_intent"));
        this.tvIntent.setMaxWidth((int)((float)Styles.getScreenWidth(this.getContext()) * 0.6f));
        this.tvIntent.setOnClickListener(this);
        this.subIntentAdapter = new SmartIntentAdapter(this.getContext(), this);
        this.setVisibility(8);
    }

    public void updateViewVisibility() {
        if (this.tvIntent == null || this.svIntent == null) {
            return;
        }
        this.currentProcess = ProcessEntranceHelper.INSTANCE.getCurrentProcess();
        this.tvIntent.setText(this.currentProcess.getSmartIntentName());
        if (TicketStatusTracker.isTicketServingByAgent() || TicketStatusTracker.isTicketServingByRPA()) {
            this.setVisibility(8);
            this.tvIntent.setVisibility(8);
            this.svIntent.setVisibility(8);
        } else if (TicketStatusTracker.isTicketActive && TicketStatusTracker.isTicketServingByAnswerBot()) {
            if (this.currentProcess != null && this.currentProcess.isEnableInteraction() && !ListUtil.isListEmpty(this.currentProcess.getSmartIntentList())) {
                this.setVisibility(0);
                this.tvIntent.setVisibility(0);
                this.svIntent.setVisibility(8);
            } else {
                this.setVisibility(8);
                this.tvIntent.setVisibility(8);
                this.svIntent.setVisibility(8);
            }
        } else {
            this.showRootIntents();
        }
    }

    public void showRootIntents() {
        List<IntentEntity> smartIntentList = this.currentProcess.getSmartIntentList();
        if (!ListUtil.isListEmpty(smartIntentList)) {
            this.setVisibility(0);
            this.subIntentAdapter.clear();
            this.tvIntent.setVisibility(8);
            this.svIntent.setVisibility(0);
            this.svIntent.scrollIntentTo(0);
            TextView tvTitle = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_root_title"));
            tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
            RecyclerView rvIntent = (RecyclerView)this.findViewById(ResResolver.getViewId("aihelp_rv_root_intent"));
            rvIntent.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
            SmartIntentAdapter actionAdapter = new SmartIntentAdapter(this.getContext(), this);
            rvIntent.setAdapter((RecyclerView.Adapter)actionAdapter);
            actionAdapter.update(smartIntentList);
            ImageView ivClose = (ImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_root_close"));
            Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");
            ivClose.setOnClickListener((View.OnClickListener)this);
        } else {
            this.setVisibility(8);
        }
    }

    public void showSubIntents(IntentEntity entity) {
        ImageView ivBack = (ImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_sub_back"));
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back");
        ivBack.setOnClickListener((View.OnClickListener)this);
        TextView tvTitle = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_sub_title"));
        Styles.reRenderTextView(tvTitle, entity.getIntentName(), Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
        tvTitle.setOnClickListener((View.OnClickListener)this);
        RecyclerView rvSubIntent = (RecyclerView)this.findViewById(ResResolver.getViewId("aihelp_rv_sub_intent"));
        rvSubIntent.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        rvSubIntent.setAdapter((RecyclerView.Adapter)this.subIntentAdapter);
        this.subIntentAdapter.update(entity.getIntentList());
        ImageView ivClose = (ImageView)this.findViewById(ResResolver.getViewId("aihelp_iv_sub_close"));
        Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");
        ivClose.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_tv_intent")) {
            this.showRootIntents();
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_root_close") || v.getId() == ResResolver.getViewId("aihelp_iv_sub_close")) {
            this.tvIntent.setVisibility(this.currentProcess.isEnableInteraction() ? 0 : 8);
            this.svIntent.setVisibility(8);
            this.subIntentAdapter.clear();
            this.svIntent.scrollIntentTo(0);
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_sub_back") || v.getId() == ResResolver.getViewId("aihelp_tv_sub_title")) {
            this.subIntentAdapter.clear();
            this.svIntent.scrollIntentTo(0);
        }
    }

    @Override
    public void onIntentSelected(IntentEntity intent, boolean hasNext) {
        if (hasNext) {
            this.showSubIntents(intent);
            this.svIntent.scrollIntentTo(Integer.MAX_VALUE);
            return;
        }
        if (this.intentViewEventListener != null && intent != null) {
            SoftInputUtil.hideSoftInput(this.getContext(), (View)this.svIntent);
            this.intentViewEventListener.onIntentSelected(intent);
            AIHelpEventTracker.getInstance().selectSmartIntent(String.valueOf(intent.getIntentId()));
            this.svIntent.setVisibility(8);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.intentViewEventListener != null) {
            this.intentViewEventListener.onIntentViewVisibilityChanged(visibility);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof OrientationChangeEvent) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    SmartIntentView.this.updateViewVisibility();
                    if (SmartIntentView.this.tvIntent != null) {
                        SmartIntentView.this.tvIntent.setMaxWidth((int)((float)Styles.getScreenWidth(SmartIntentView.this.getContext()) * 0.6f));
                    }
                    if (SmartIntentView.this.svIntent != null && SmartIntentView.this.svIntent.getVisibility() == 0) {
                        SmartIntentView.this.showRootIntents();
                    }
                }
            });
        }
    }
}

