/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.rpa.factory;

import android.text.TextUtils;
import java.util.regex.Pattern;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.AgentMessage;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.cs.util.rpa.factory.MessageFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class AgentMessageFactory
extends MessageFactory {
    public static Message getAgentMessage(String msg, long timestamp, String nickname) {
        switch (AgentMessageFactory.getAgentMessageType(msg)) {
            case 6: {
                return AgentMessageFactory.getAgentImageMessage(msg, timestamp, nickname);
            }
            case 7: {
                return AgentMessageFactory.getAgentVideoMessage(msg, timestamp, nickname);
            }
            case 9: {
                return AgentMessageFactory.getAgentFileMessage(msg, timestamp, nickname);
            }
            case 8: {
                return AgentMessageFactory.getAgentRichTextMessage(msg, timestamp, nickname);
            }
        }
        return AgentMessageFactory.getAgentTextMessage(msg, timestamp, nickname);
    }

    private static int getAgentMessageType(String message) {
        if (AgentMessageFactory.isAgentImage(message)) {
            return 6;
        }
        if (AgentMessageFactory.isAgentVideo(message)) {
            return 7;
        }
        if (AgentMessageFactory.isAgentAttachment(message)) {
            return 9;
        }
        if (AgentMessageFactory.isAgentRichText(message)) {
            return 8;
        }
        return 3;
    }

    private static Message getAgentTextMessage(String msg, long timestamp, String nickname) {
        AgentMessage agentMessage = new AgentMessage(nickname);
        agentMessage.setTimestamp(timestamp);
        agentMessage.setContent(AgentMessageFactory.getPeeledContent(msg));
        agentMessage.setNormalMessage(true);
        return agentMessage;
    }

    private static Message getAgentRichTextMessage(String message, long timestamp, String nickname) {
        AgentMessage agentMessage = new AgentMessage(nickname);
        agentMessage.setTimestamp(timestamp);
        StringBuilder contentBuilder = new StringBuilder(AgentMessageFactory.getPeeledContent(message));
        JSONObject contentObject = AgentMessageFactory.getContentObject(JsonHelper.getJsonObject(message));
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        for (int i = 0; i < attachments.length(); ++i) {
            JSONObject attachItem = JsonHelper.getJsonObject(attachments, i);
            contentBuilder.append("\n").append(JsonHelper.optString(attachItem, "url"));
        }
        agentMessage.setContent(contentBuilder.toString());
        agentMessage.setNormalMessage(true);
        return agentMessage;
    }

    private static Message getAgentImageMessage(String msg, long timestamp, String nickname) {
        FileMessage imageMsg = new FileMessage(6, AgentMessageFactory.getPeeledContent(msg));
        if (AgentMessageFactory.isAgentAttachment(msg)) {
            imageMsg = AgentMessageFactory.getAttachmentMessage(msg, 6);
        }
        imageMsg.setTimestamp(timestamp);
        imageMsg.setNickname(nickname);
        imageMsg.setNormalMessage(true);
        return imageMsg;
    }

    private static Message getAgentVideoMessage(String msg, long timestamp, String nickname) {
        FileMessage videoMsg = new FileMessage(7, AgentMessageFactory.getPeeledContent(msg));
        if (AgentMessageFactory.isAgentAttachment(msg)) {
            videoMsg = AgentMessageFactory.getAttachmentMessage(msg, 7);
        }
        videoMsg.setTimestamp(timestamp);
        videoMsg.setNickname(nickname);
        videoMsg.setNormalMessage(true);
        return videoMsg;
    }

    private static Message getAgentFileMessage(String msg, long timestamp, String nickname) {
        FileMessage fileMessage = AgentMessageFactory.getAttachmentMessage(msg, 9);
        fileMessage.setNickname(nickname);
        fileMessage.setTimestamp(timestamp);
        fileMessage.setNormalMessage(true);
        return fileMessage;
    }

    private static boolean isAgentText(String message) {
        return !TextUtils.isEmpty((CharSequence)AgentMessageFactory.getPeeledContent(message));
    }

    private static boolean isAgentImage(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(AgentMessageFactory.getPeeledContent(message)).matches() || AgentMessageFactory.isAttachmentImage(message);
    }

    private static boolean isAgentVideo(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(AgentMessageFactory.getPeeledContent(message)).matches() || AgentMessageFactory.isAttachmentVideo(message);
    }

    private static boolean isAgentRichText(String message) {
        String replyContent = AgentMessageFactory.getPeeledContent(message);
        return !TextUtils.isEmpty((CharSequence)replyContent) && AgentMessageFactory.hasAtLeastNAttachments(message, 1) || TextUtils.isEmpty((CharSequence)replyContent) && AgentMessageFactory.hasAtLeastNAttachments(message, 2);
    }

    private static boolean isAgentAttachment(String message) {
        return TextUtils.isEmpty((CharSequence)AgentMessageFactory.getPeeledContent(message)) && AgentMessageFactory.hasOnlyOneAttachment(message);
    }
}

