/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.rpa.factory;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.bot.Answer;
import net.aihelp.data.model.rpa.msg.bot.ExternalUrl;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.model.rpa.msg.bot.FormUrl;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.ui.cs.util.rpa.factory.MessageFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class BotMessageFactory
extends MessageFactory {
    private static final int BOT_REPLY_TYPE_TEXT = 0;
    private static final int BOT_REPLY_TYPE_FORM_CONTENT = 1;
    private static final int BOT_REPLY_TYPE_ATTACHMENT = 2;
    private static final int BOT_REPLY_TYPE_EXTERNAL_URL = 3;
    private static final int BOT_REPLY_TYPE_FAQ = 4;
    private static final int BOT_REPLY_TYPE_SELF_SERVICE = 5;
    private static final int BOT_REPLY_TYPE_FORM_URL = 6;

    public static BotMessage getHistoricBotMessage(String msg, long timestamp, String nickname, int historyType) {
        JSONObject historyMessage = JsonHelper.getJsonObject(msg);
        BotMessage botMessage = new BotMessage(nickname);
        botMessage.setTimestamp(timestamp);
        botMessage.setContent(BotMessageFactory.getPeeledContent(msg));
        botMessage.setExternalUrl(BotMessageFactory.getHistoryExternalUrl(historyMessage));
        botMessage.setFaq(BotMessageFactory.getHistoryFaq(historyMessage));
        botMessage.setSelfService(BotMessageFactory.getHistorySelfService(historyMessage));
        botMessage.setBotAnswers(BotMessageFactory.getHistoryBotAnswers(historyMessage, historyType));
        botMessage.setUserFeedback(BotMessageFactory.getHistoryUserFeedback(historyMessage, historyType));
        return botMessage;
    }

    public static BotMessage getResponseBotMessage(JSONObject bot, long timestamp, String nickname) {
        int status = bot.optInt("status", -1);
        JSONObject botReply = JsonHelper.getJsonObject(bot, "reply");
        BotMessage botMessage = new BotMessage(nickname);
        botMessage.setNormalMessage(status == 1001);
        botMessage.setDuringRPAProcedure(status == 1001 || status == 1002);
        botMessage.setTimestamp(timestamp);
        botMessage.setContent(BotMessageFactory.getBotContent(botReply));
        botMessage.setFormUrl(BotMessageFactory.getFormUrl(botReply));
        botMessage.setExternalUrl(BotMessageFactory.getExternalUrl(botReply));
        botMessage.setFaq(BotMessageFactory.getRPAFaq(botReply, botMessage));
        botMessage.setSelfService(BotMessageFactory.getSelfService(botReply));
        botMessage.setBotAnswers(BotMessageFactory.getBotAnswers(botReply));
        return botMessage;
    }

    public static <T> T getAttachmentContent(String message, String attachmentKey, T fallback) {
        JSONObject contentObject = BotMessageFactory.getContentObject(JsonHelper.getJsonObject(message));
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        if (attachments.length() > 0) {
            JSONObject attachItem = JsonHelper.getJsonObject(attachments, 0);
            return JsonHelper.opt(attachItem, attachmentKey, fallback);
        }
        return fallback;
    }

    public static String getBotContent(JSONObject jsonObject) {
        return JsonHelper.optString(jsonObject, "botReply");
    }

    public static Faq getHistoryFaq(JSONObject historyMessage) {
        JSONObject contentObject = BotMessageFactory.getContentObject(historyMessage);
        JSONArray historyFaqList = JsonHelper.getJsonArray(contentObject, "faqList");
        return BotMessageFactory._getFaq(historyFaqList, false);
    }

    public static Faq getRPAFaq(JSONObject jsonObject, BotMessage botMessage) {
        JSONObject faqData = JsonHelper.getJsonObject(jsonObject, "faqData");
        String faqMsg = JsonHelper.optString(faqData, "msg");
        if (!TextUtils.isEmpty((CharSequence)faqMsg) && TextUtils.isEmpty((CharSequence)botMessage.getContent())) {
            botMessage.setContent(faqMsg);
        }
        JSONArray mqttFaqList = JsonHelper.getJsonArray(faqData, "reply");
        boolean isSimilarMatch = faqData.optInt("isSimilarMatch") == 1;
        return BotMessageFactory._getFaq(mqttFaqList, isSimilarMatch);
    }

    private static Faq _getFaq(JSONArray faqList, boolean isSimilarMatch) {
        ArrayList<Faq.FaqData> faqDataList = new ArrayList<Faq.FaqData>();
        for (int i = 0; i < faqList.length(); ++i) {
            faqDataList.add(BotMessageFactory.getFaqData(JsonHelper.getJsonObject(faqList, i), 1));
        }
        return new Faq(isSimilarMatch, faqDataList);
    }

    public static Faq.FaqData getFaqData(JSONObject faq, int faqSource) {
        long mainId = faq.optLong("mainId");
        long contentId = faq.optLong("contentId");
        String faqTitle = JsonHelper.optString(faq, "faqTitle");
        String faqContent = JsonHelper.optString(faq, "faqContent");
        String template = JsonHelper.optString(faq, "template");
        JSONObject formObject = JsonHelper.getJsonObject(faq, "form");
        String formUrl = JsonHelper.optString(formObject, "url");
        String formTitle = JsonHelper.optString(formObject, "title");
        boolean isSimilarMatch = formObject.optBoolean("isSimilarMatch");
        boolean isShowMore = faq.optBoolean("isShowMore", false);
        return new Faq.FaqData(faqSource, mainId, contentId, faqTitle, faqContent, template, formUrl, formTitle, isSimilarMatch, isShowMore);
    }

    public static SelfService getHistorySelfService(JSONObject historyMessage) {
        JSONObject contentObject = BotMessageFactory.getContentObject(historyMessage);
        boolean enableSending = contentObject.optInt("allowSend") == 1;
        JSONArray rows = JsonHelper.getJsonArray(contentObject, "apiData");
        return new SelfService(enableSending, BotMessageFactory.getSelfServiceData(rows));
    }

    public static SelfService getSelfService(JSONObject jsonObject) {
        JSONObject apiData = JsonHelper.getJsonObject(jsonObject, "apiData");
        boolean enableSending = apiData.optInt("allowSend") == 1;
        JSONArray rows = JsonHelper.getJsonArray(apiData, "rows");
        return new SelfService(enableSending, BotMessageFactory.getSelfServiceData(rows));
    }

    public static String getSelfServiceData(JSONArray rows) {
        JSONArray selfServiceArray = new JSONArray();
        for (int i = 0; i < rows.length(); ++i) {
            JSONArray dataArray = JsonHelper.getJsonArray(JsonHelper.getJsonObject(rows, i), "row");
            try {
                JSONObject selfServiceData = new JSONObject();
                for (int j = 0; j < dataArray.length(); ++j) {
                    JSONObject cell = JsonHelper.getJsonObject(dataArray, j);
                    selfServiceData.put(JsonHelper.optString(cell, "key"), cell.opt("value"));
                }
                selfServiceArray.put((Object)selfServiceData);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return selfServiceArray.toString();
    }

    public static FormUrl getHistoryFormUrl(JSONObject jsonObject) {
        JSONObject contentObject = BotMessageFactory.getContentObject(jsonObject);
        try {
            contentObject.put("msgType", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BotMessageFactory.getMessageType(jsonObject) == 6 ? BotMessageFactory.getFormUrl(contentObject) : null;
    }

    public static FormUrl getFormUrl(JSONObject jsonObject) {
        boolean isFormUrl = jsonObject.optInt("msgType") == 1;
        String title = JsonHelper.optString(jsonObject, "title");
        String url = JsonHelper.optString(jsonObject, "url");
        return isFormUrl ? new FormUrl(title, url) : null;
    }

    public static ExternalUrl getHistoryExternalUrl(JSONObject jsonObject) {
        JSONObject contentObject = BotMessageFactory.getContentObject(jsonObject);
        return BotMessageFactory.getMessageType(jsonObject) == 3 ? BotMessageFactory.getExternalUrl(contentObject) : null;
    }

    public static ExternalUrl getExternalUrl(JSONObject jsonObject) {
        boolean isExternalUrl = jsonObject.optInt("msgType") != 1;
        String title = JsonHelper.optString(jsonObject, "title");
        String url = JsonHelper.optString(jsonObject, "url");
        return isExternalUrl ? new ExternalUrl(title, url) : null;
    }

    public static List<Answer> getHistoryBotAnswers(JSONObject historyMessage, int historyType) {
        ArrayList<Answer> botAnswers = new ArrayList<Answer>();
        JSONArray jsonArray = JsonHelper.getJsonArray(BotMessageFactory.getContentObject(historyMessage), "answerData");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject answerData = JsonHelper.getJsonObject(jsonArray, i);
            Answer answer = new Answer(answerData.optInt("type"), JsonHelper.optString(answerData, "answerTitle"));
            answer.setFaqData(BotMessageFactory.getFaqData(JsonHelper.getJsonObject(answerData, "data"), 2));
            botAnswers.add(answer);
        }
        return botAnswers;
    }

    public static List<Answer> getBotAnswers(JSONObject jsonObject) {
        ArrayList<Answer> botAnswers = new ArrayList<Answer>();
        JSONArray jsonArray = JsonHelper.getJsonArray(jsonObject, "answerData");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject answerData = JsonHelper.getJsonObject(jsonArray, i);
            Answer answer = new Answer(answerData.optInt("type"), JsonHelper.optString(answerData, "answerTitle"));
            answer.setFaqData(BotMessageFactory.getFaqData(JsonHelper.getJsonObject(answerData, "data"), 2));
            botAnswers.add(answer);
        }
        return botAnswers;
    }

    public static int getHistoryUserFeedback(@NonNull JSONObject historyMessage, int historyType) {
        int feedback = historyMessage.optInt("feedback");
        if (historyType == 2 && feedback == 0) {
            feedback = -1;
        }
        return feedback;
    }
}

