/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.rpa.factory;

import android.text.TextUtils;
import java.util.regex.Pattern;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.FileMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageFactory {
    public static String getPeeledContent(String message) {
        try {
            JSONObject botMessage = new JSONObject(message);
            String contentStr = JsonHelper.optString(botMessage, "content");
            try {
                JSONObject rpaBot = new JSONObject(contentStr);
                return JsonHelper.optString(rpaBot, "reply");
            }
            catch (Exception e) {
                return contentStr;
            }
        }
        catch (Exception e) {
            return message;
        }
    }

    public static boolean isAgentMsg(String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            return jsonObject.optInt("usertype") == 0 && jsonObject.isNull("bot") && !TextUtils.isEmpty((CharSequence)JsonHelper.optString(jsonObject, "msg"));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static JSONObject getContentObject(JSONObject historyMessage) {
        if (JsonHelper.hasKey(historyMessage, "content")) {
            String contentJsonString = JsonHelper.optString(historyMessage, "content");
            try {
                return new JSONObject(contentJsonString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return historyMessage == null ? new JSONObject() : historyMessage;
    }

    protected static int getMessageType(JSONObject messageObject) {
        try {
            return messageObject.optInt("type");
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static FileMessage getAttachmentMessage(String message, int msgType) {
        String fileUrl = MessageFactory.getAttachmentContent(message, "url", "");
        String fileName = MessageFactory.getAttachmentContent(message, "filename", "");
        int fileSize = MessageFactory.getAttachmentContent(message, "size", 0);
        FileMessage fileMessage = new FileMessage(msgType, fileUrl);
        fileMessage.setFileInfo(fileName, fileSize);
        fileMessage.setNormalMessage(true);
        return fileMessage;
    }

    public static <T> T getAttachmentContent(String message, String attachmentKey, T fallback) {
        return MessageFactory.getAttachmentContent(message, 0, attachmentKey, fallback);
    }

    public static <T> T getAttachmentContent(String message, int index, String attachmentKey, T fallback) {
        JSONObject attachItem;
        Object result;
        JSONObject contentObject = MessageFactory.getContentObject(JsonHelper.getJsonObject(message));
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        if (attachments.length() > 0 && index <= attachments.length() - 1 && (result = (attachItem = JsonHelper.getJsonObject(attachments, index)).opt(attachmentKey)) != null) {
            if (fallback instanceof String && result.toString().equals(JSONObject.NULL.toString())) {
                return fallback;
            }
            return (T)result;
        }
        return fallback;
    }

    public static boolean isAttachmentImage(String message) {
        if (MessageFactory.hasOnlyOneAttachment(message) && TextUtils.isEmpty((CharSequence)MessageFactory.getPeeledContent(message))) {
            String type = MessageFactory.getAttachmentContent(message, "type", "");
            return Pattern.compile("(?i)(png|jpg|jpeg|gif)").matcher(type).matches();
        }
        return false;
    }

    public static boolean isAttachmentVideo(String message) {
        if (MessageFactory.hasOnlyOneAttachment(message) && TextUtils.isEmpty((CharSequence)MessageFactory.getPeeledContent(message))) {
            String type = MessageFactory.getAttachmentContent(message, "type", "");
            return Pattern.compile("(?i)(mp4|3gp|mkv|webm)").matcher(type).matches();
        }
        return false;
    }

    private static int sizeOfAttachments(String message) {
        JSONObject msgObject = JsonHelper.getJsonObject(message);
        JSONObject contentObject = MessageFactory.getContentObject(msgObject);
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        return attachments.length();
    }

    public static boolean hasOnlyOneAttachment(String message) {
        return MessageFactory.sizeOfAttachments(message) == 1;
    }

    public static boolean hasAtLeastNAttachments(String message, int atLeast) {
        return MessageFactory.sizeOfAttachments(message) >= atLeast;
    }
}

