/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.rpa.factory;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.data.model.rpa.msg.FileMessage;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.cs.util.rpa.factory.MessageFactory;

public class UserMessageFactory
extends MessageFactory {
    public static List<Message> getUserMessage(String msg, long timestamp) {
        switch (UserMessageFactory.getUserMessageType(msg)) {
            case 11: {
                return UserMessageFactory.getUserImageMessage(msg, timestamp);
            }
            case 12: {
                return UserMessageFactory.getUserVideoMessage(msg, timestamp);
            }
            case 14: {
                return UserMessageFactory.getUserFileMessage(msg, timestamp);
            }
        }
        return UserMessageFactory.getUserTextMessage(msg, timestamp);
    }

    private static int getUserMessageType(String message) {
        if (UserMessageFactory.isUserImage(message)) {
            return 11;
        }
        if (UserMessageFactory.isUserVideo(message)) {
            return 12;
        }
        if (UserMessageFactory.isUserAttachment(message)) {
            return 14;
        }
        return 10;
    }

    private static List<Message> getUserTextMessage(String msg, long timestamp) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        UserMessage userMessage = new UserMessage();
        String msgContent = UserMessageFactory.getPeeledContent(msg);
        userMessage.setTimestamp(timestamp);
        userMessage.setContent(msgContent);
        msgList.add(userMessage);
        UserMessageFactory.replaceMediaUrls(msgContent, msgList, userMessage);
        return msgList;
    }

    private static List<Message> getUserImageMessage(String msg, long timestamp) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        FileMessage imageMessage = new FileMessage(11, msg);
        if (UserMessageFactory.isUserAttachment(msg)) {
            imageMessage = UserMessageFactory.getAttachmentMessage(msg, 11);
        }
        imageMessage.setTimestamp(timestamp);
        msgList.add(imageMessage);
        return msgList;
    }

    private static List<Message> getUserVideoMessage(String msg, long timestamp) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        FileMessage videoMessage = new FileMessage(12, msg);
        if (UserMessageFactory.isUserAttachment(msg)) {
            videoMessage = UserMessageFactory.getAttachmentMessage(msg, 12);
        }
        videoMessage.setTimestamp(timestamp);
        msgList.add(videoMessage);
        return msgList;
    }

    private static List<Message> getUserFileMessage(String msg, long timestamp) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        FileMessage fileMessage = UserMessageFactory.getAttachmentMessage(msg, 14);
        fileMessage.setTimestamp(timestamp);
        fileMessage.setNormalMessage(true);
        msgList.add(fileMessage);
        return msgList;
    }

    private static boolean isUserText(String message) {
        return !TextUtils.isEmpty((CharSequence)UserMessageFactory.getPeeledContent(message));
    }

    private static boolean isUserImage(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(message).matches() || UserMessageFactory.isAttachmentImage(message);
    }

    private static boolean isUserVideo(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(message).matches() || UserMessageFactory.isAttachmentVideo(message);
    }

    private static boolean isUserAttachment(String message) {
        return UserMessageFactory.hasOnlyOneAttachment(message);
    }

    public static List<Message> getUserFormMsgList(String msg) {
        ArrayList<Message> formMsgList = new ArrayList<Message>();
        UserMessage userMessage = new UserMessage();
        userMessage.setContent(msg);
        formMsgList.add(userMessage);
        UserMessageFactory.replaceMediaUrls(msg, formMsgList, userMessage);
        return formMsgList;
    }

    private static void replaceMediaUrls(String msg, ArrayList<Message> formMsgList, Message message) {
        String[] messageSplits;
        int fakeTimeStamp = 10;
        for (String item : messageSplits = msg.split(";")) {
            Matcher replaceImageMatcher = Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(item.trim());
            while (replaceImageMatcher.find()) {
                String imageUrl = replaceImageMatcher.group();
                FileMessage formImageMsg = new FileMessage(11, imageUrl);
                formImageMsg.setTimestamp(message.getTimestamp() + (long)fakeTimeStamp++);
                formMsgList.add(formImageMsg);
                msg = msg.replace(imageUrl, "");
            }
            Matcher replaceVideoMatcher = Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(msg);
            while (replaceVideoMatcher.find()) {
                String videoUrl = replaceVideoMatcher.group();
                FileMessage formVideoMsg = new FileMessage(12, videoUrl);
                formVideoMsg.setTimestamp(message.getTimestamp() + (long)fakeTimeStamp++);
                formMsgList.add(formVideoMsg);
                msg = msg.replace(videoUrl, "");
            }
        }
    }
}

