/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.rpa.helper;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.AIHelpEventTracker;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.cs.util.rpa.factory.AgentMessageFactory;
import net.aihelp.ui.cs.util.rpa.factory.BotMessageFactory;
import net.aihelp.ui.cs.util.rpa.factory.MessageFactory;
import net.aihelp.ui.cs.util.rpa.helper.HistoryHelper;
import net.aihelp.utils.DeviceInfoUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResponseHelper {
    public static final int RPA_PROCEDURE_TICKET_CREATED = 1;
    public static final int RPA_PROCEDURE_TICKET_RESET = 2;
    public static final int RPA_PROCEDURE_BOT_NORMAL = 1001;
    public static final int RPA_PROCEDURE_BOT_STOP_AND_WAIT = 1002;
    public static final int RPA_PROCEDURE_AGENT_ALREADY_ASSIGNED = 2001;

    public static Message getRPAMessage(String response) {
        if (TextUtils.isEmpty((CharSequence)response)) {
            Message message = new Message(3);
            message.setNormalMessage(false);
            return message;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            boolean isAgent = jsonObject.has("usertype") && jsonObject.optInt("usertype") == 0;
            String nickname = JsonHelper.optString(jsonObject, "nickname");
            long timestamp = jsonObject.optLong("time");
            if (isAgent) {
                String msg = JsonHelper.optString(jsonObject, "msg");
                return AgentMessageFactory.getAgentMessage(msg, timestamp, nickname);
            }
            JSONObject bot = JsonHelper.getJsonObject(jsonObject, "bot");
            return BotMessageFactory.getResponseBotMessage(bot, timestamp, nickname);
        }
        catch (Exception e) {
            e.printStackTrace();
            Message message = new Message(3);
            message.setNormalMessage(false);
            return message;
        }
    }

    public static RPAStep getRPAStep(String response) {
        boolean isTicketAlreadyFinished;
        RPAStep rpaStep = new RPAStep();
        boolean bl = isTicketAlreadyFinished = TicketStatusTracker.isTicketFinished && (TicketStatusTracker.isTicketWaitForAskingResolveStatus || TicketStatusTracker.isTicketWaitForRating);
        if (MessageFactory.isAgentMsg(response) || isTicketAlreadyFinished) {
            rpaStep.setNextStep(104);
            return rpaStep;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONObject bot = JsonHelper.getJsonObject(jsonObject, "welcomeBot");
            if (bot.length() == 0) {
                bot = JsonHelper.getJsonObject(jsonObject, "bot");
            }
            int status = bot.optInt("status", -1);
            switch (status) {
                case 1002: {
                    rpaStep.setNextStep(103);
                    break;
                }
                case 2: {
                    rpaStep.setNextStep(102);
                    break;
                }
                case 1: {
                    Const.TOGGLE_FETCH_MESSAGE = true;
                    TicketStatusTracker.isTicketActive = true;
                    TicketStatusTracker.currentTicketId = JsonHelper.optString(jsonObject, "ticketId");
                }
                case 2001: {
                    rpaStep.setNextStep(104);
                    break;
                }
                default: {
                    JSONObject botStep = JsonHelper.getJsonObject(bot, "step");
                    if (botStep.keys().hasNext()) {
                        rpaStep.setStepId(JsonHelper.optString(botStep, "stepId"));
                        rpaStep.setEnablePrevStep(botStep.optInt("allowBack") == 1);
                        rpaStep.setEnableSkip(botStep.optInt("allowSkip") == 1);
                        rpaStep.setEnableUpload(botStep.optInt("autoUpload") == 1);
                        rpaStep.setNextStep(botStep.optInt("nextAction"));
                        rpaStep.setSkipHint(JsonHelper.optString(botStep, "skipLabel"));
                        rpaStep.setPrevStepHint(JsonHelper.optString(botStep, "backLabel"));
                        rpaStep.setEnableActionInput(botStep.optInt("allowInputBox") == 1);
                        rpaStep.setAttachmentTypes(JsonHelper.optString(botStep, "attachmentsTypes"));
                        JSONArray actionArray = JsonHelper.getJsonArray(botStep, "buttons");
                        ArrayList<RPAStep.Action> actionList = new ArrayList<RPAStep.Action>();
                        for (int i = 0; i < actionArray.length(); ++i) {
                            JSONObject action = JsonHelper.getJsonObject(actionArray, i);
                            int order = action.optInt("order");
                            String actionId = JsonHelper.optString(action, "id");
                            String actionContent = JsonHelper.optString(action, "value");
                            actionList.add(RPAStep.Action.getInstance(order, actionId, actionContent));
                        }
                        rpaStep.setActionList(actionList);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rpaStep;
    }

    public static void notifyMqttPush(String response) {
        try {
            JSONObject mqttNotifyParams = new JSONObject();
            mqttNotifyParams.put("timestamp", System.currentTimeMillis());
            if (!TextUtils.isEmpty((CharSequence)response)) {
                mqttNotifyParams.put("responseId", (Object)JsonHelper.optString(new JSONObject(response), "responseId"));
            }
            AIHelpRequest.getInstance().requestGetByAsync(API.NOTIFY_MQTT_PUSH, mqttNotifyParams, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Message> getLoginResponse(String response) {
        String evaluation;
        ArrayList<Message> list = new ArrayList<Message>();
        JSONObject loginObj = JsonHelper.getJsonObject(response);
        list.add(Message.getDefaultMessage());
        TicketStatusTracker.firstMessageTimeStampInList = System.currentTimeMillis();
        List<Message> historyList = ResponseHelper.getHistoryMessageList(response, 1);
        TicketStatusTracker.setFirstMessageTimeStampInList(historyList);
        list.addAll(historyList);
        ResponseHelper.updateTicketStatusTracker(response);
        if (JsonHelper.hasKey(loginObj, "evaluation") && !TextUtils.isEmpty((CharSequence)(evaluation = JsonHelper.optString(loginObj, "evaluation")))) {
            JSONArray jsonArray = JsonHelper.getJsonArray(evaluation);
            FeedbackOpinionHelper.INSTANCE.prepareDataSource(jsonArray);
        }
        if (JsonHelper.hasKey(loginObj, "expandField")) {
            JSONObject expandField = JsonHelper.getJsonObject(loginObj, "expandField");
            TicketStatusTracker.ticketPollInterval = expandField.optInt("ticketPollInterval", 60);
        }
        return list;
    }

    public static List<Message> getPollResponse(String response) {
        ResponseHelper.updateTicketStatusTracker(response);
        return ResponseHelper.getHistoryMessageList(response, 3);
    }

    private static List<Message> getHistoryMessageList(String response, int historyType) {
        JSONObject jsonObject = JsonHelper.getJsonObject(response);
        if (JsonHelper.hasKey(jsonObject, "chatHistoryContent")) {
            String chatHistoryContent = JsonHelper.optString(jsonObject, "chatHistoryContent");
            return HistoryHelper.getHistoryList(chatHistoryContent, historyType);
        }
        return new ArrayList<Message>();
    }

    private static void updateTicketStatusTracker(String response) {
        JSONObject jsonObject = JsonHelper.getJsonObject(response);
        if (JsonHelper.hasKey(jsonObject, "chatExtraInfo")) {
            JSONObject chatExtraInfo = JsonHelper.getJsonObject(jsonObject.optString("chatExtraInfo"));
            boolean hasTicket = chatExtraInfo.optBoolean("hasTicket");
            int assignType = chatExtraInfo.optInt("assignType");
            TicketStatusTracker.updateAssignTypeWithActiveStatus(hasTicket, assignType);
            TicketStatusTracker.isTicketFinished = chatExtraInfo.optBoolean("isEvaluate");
            TicketStatusTracker.isTicketWaitForAskingResolveStatus = chatExtraInfo.optBoolean("isShowResolve");
            TicketStatusTracker.isAppRatable = chatExtraInfo.optBoolean("isStoreReview");
            TicketStatusTracker.isTicketWaitForRating = CustomConfig.CustomerService.isTicketRatingEnable;
            TicketStatusTracker.isTicketRejected = chatExtraInfo.optInt("status") == 9;
            TicketStatusTracker.currentTicketId = JsonHelper.optString(chatExtraInfo, "ticketId");
        }
    }

    public static JSONObject getLoginParams() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("appId", (Object)Const.APP_ID);
            obj.put("userId", (Object)UserProfile.USER_ID);
            obj.put("userName", (Object)UserProfile.USER_NAME);
            obj.put("type", 1);
            obj.put("lan", (Object)Const.CORRECT_LANGUAGE);
            obj.put("sdkVersion", (Object)"4.3.15");
            obj.put("source", (Object)"android");
            obj.put("gameInfo", (Object)DeviceInfoUtil.getInstance().getGameInfo().toString());
            obj.put("extendData", (Object)AIHelpEventTracker.getInstance().getExtendDataForLogin());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

