/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.viewer;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.ui.helper.WebViewInjector;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateButtonView;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public enum BotFaqViewer implements View.OnClickListener
{
    INSTANCE;

    private AlertDialog faqAlertDialog = null;
    private AIHelpWebView mWebView = null;

    public void show(Context context, final BotMessage botMessage, final Faq.FaqData faq, final OnFaqEvaluateListener evaluateListener) {
        String url = DomainSupportHelper.getAdjustedUrl(faq.getFaqContent());
        if (!url.contains("isCustom=1")) {
            url = url + "&isCustom=1";
        }
        this.faqAlertDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_elva_faq")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (EventBus.getDefault().isRegistered(this)) {
                    EventBus.getDefault().unregister((Object)BotFaqViewer.this);
                }
            }
        }).setWidthAndHeight(-1, 500).setHeightByDevice().create();
        RelativeLayout rootLayout = (RelativeLayout)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_rl_root"));
        rootLayout.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));
        final ImageView ivBack = (ImageView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        ivBack.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back");
        ImageView ivClose = (ImageView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        ivClose.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");
        this.mWebView = (AIHelpWebView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_web_view"));
        this.mWebView.setBackgroundColor(0);
        final AIHelpWebProgress progressBar = (AIHelpWebProgress)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(context, progressBar);
        webViewClient.setUrlLoadingListener(new AIHelpWebViewClient.ShouldOverrideUrlLoadingListener(){

            @Override
            public void handleUrlClick(boolean result) {
                ivBack.setVisibility(0);
            }
        });
        this.mWebView.setWebViewClient(webViewClient);
        WebViewInjector.getInstance().setContext(context).inject(this.mWebView, webViewClient);
        this.mWebView.setWebChromeClient(new WebChromeClient(){
            boolean isFinishedAlready;

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                progressBar.setProgress(newProgress);
                if (newProgress == 100 && !this.isFinishedAlready) {
                    view.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (faq.getFaqSource() == 2) {
                                BotFaqViewer.this.prepareEvaluateButtonView(botMessage, faq, evaluateListener);
                            }
                        }
                    }, 500L);
                    this.isFinishedAlready = true;
                }
            }
        });
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mWebView.loadUrl(url);
        this.faqAlertDialog.show();
        TLog.d("BotFaq: " + url);
    }

    private void prepareEvaluateButtonView(final BotMessage botMessage, final Faq.FaqData faq, final OnFaqEvaluateListener evaluateListener) {
        AIHelpEvaluateButtonView evaluateButtonView = (AIHelpEvaluateButtonView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_evaluate_view"));
        evaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        evaluateButtonView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateButtonView.OnAIHelpEvaluateViewCallback(){

            @Override
            public void onEvaluated(boolean isHelpful) {
                botMessage.setUserFeedback(isHelpful ? 1 : 2);
                if (evaluateListener != null) {
                    evaluateListener.onEvaluated(botMessage, isHelpful);
                }
            }

            @Override
            public JSONObject requestDataForFeedback() {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("mainId", faq.getMainId());
                    jsonObject.put("contentId", faq.getContentId());
                    jsonObject.put("isClickDetail", faq.isFaqViewed());
                    jsonObject.put("pointMessageId", (Object)String.valueOf(botMessage.getTimestamp()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jsonObject;
            }
        });
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_iv_close") && this.faqAlertDialog != null) {
            this.faqAlertDialog.dismiss();
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_back") && this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            if (!this.mWebView.canGoBack()) {
                v.setVisibility(8);
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (this.faqAlertDialog != null && this.faqAlertDialog.isShowing()) {
            this.faqAlertDialog.dismiss();
        }
    }

    public static interface OnFaqEvaluateListener {
        public void onEvaluated(BotMessage var1, boolean var2);
    }
}

