/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.util.viewer;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.Iterator;
import java.util.UUID;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.ui.adapter.BillingListAdapter;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public class SelfServiceViewer
implements View.OnClickListener {
    private AlertDialog selfServiceDialog;
    private TextView mTvSend;
    private ImageView mIvClose;
    private RelativeLayout mEmptyLayout;
    private BillingListAdapter mAdapter;
    private OnSelfServiceConfirmListener onSelfServiceConfirmListener;

    public void getService(Context context, SelfService selfService) {
        this.selfServiceDialog = new AlertDialog.Builder(context).setContentView(ResResolver.getLayoutId("aihelp_dia_selecting_bill")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                EventBus.getDefault().unregister(SelfServiceViewer.this);
            }
        }).setWidthAndHeight(-1, 500).setHeightByDevice().create();
        LinearLayout llRoot = (LinearLayout)this.selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_ll_bill_dialog"));
        llRoot.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));
        this.mTvSend = (TextView)this.selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_tv_send"));
        Styles.reRenderTextView(this.mTvSend, ResResolver.getString("aihelp_send"), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        this.mTvSend.setOnClickListener((View.OnClickListener)this);
        this.mIvClose = (ImageView)this.selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        Styles.reRenderImageView(this.mIvClose, "aihelp_svg_ic_close_dialog");
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mEmptyLayout = (RelativeLayout)this.selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_rl_empty"));
        ListView mBillList = (ListView)this.selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_lv_bill"));
        this.mAdapter = new BillingListAdapter(context, selfService.isEnableSend());
        this.mAdapter.setOnOrderCheckedListener(new BillingListAdapter.OnOrderCheckedListener(){

            @Override
            public void onOrderChecked() {
                SelfServiceViewer.this.mTvSend.setEnabled(true);
                SelfServiceViewer.this.mTvSend.setAlpha(1.0f);
            }
        });
        mBillList.setAdapter((ListAdapter)this.mAdapter);
        this.selfServiceDialog.show();
        this.mTvSend.setVisibility(selfService.isEnableSend() ? 0 : 8);
        this.mIvClose.setVisibility(selfService.isEnableSend() ? 8 : 0);
        try {
            JSONArray jsonArray = new JSONArray(selfService.getSelfServiceData());
            if (jsonArray.length() > 0) {
                this.mAdapter.update(jsonArray);
            } else {
                this.showEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventBus.getDefault().register(this);
    }

    private void showEmpty() {
        this.mTvSend.setVisibility(8);
        this.mIvClose.setVisibility(8);
        this.mEmptyLayout.setVisibility(0);
        TextView tvError = (TextView)this.mEmptyLayout.findViewById(ResResolver.getViewId("aihelp_tv_error_desc"));
        tvError.setText((CharSequence)ResResolver.getString("aihelp_data_not_found_msg"));
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_tv_send") && FastClickValidator.validate() && AppInfoUtil.validateNetwork(v.getContext())) {
            String checkedBillJson = this.mAdapter.getCheckedBill();
            if (!TextUtils.isEmpty((CharSequence)checkedBillJson)) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    JSONObject jsonObject = new JSONObject(checkedBillJson);
                    Iterator keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        stringBuilder.append(key).append(": ").append(jsonObject.opt(key)).append("\n");
                    }
                    String content = stringBuilder.toString().trim();
                    UserMessage userMessage = Message.getUserTextMsg(content);
                    userMessage.setRequestParams(content, 1, 4);
                    if (this.onSelfServiceConfirmListener != null) {
                        this.onSelfServiceConfirmListener.onSelected(userMessage);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.selfServiceDialog != null && this.selfServiceDialog.isShowing()) {
                this.selfServiceDialog.dismiss();
            }
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_close") && FastClickValidator.validate() && this.selfServiceDialog != null && this.selfServiceDialog.isShowing()) {
            this.selfServiceDialog.dismiss();
        }
    }

    public JSONObject getRequestParams(String input, int inputFormat) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", (Object)input);
            jsonObject.put("skip", false);
            jsonObject.put("inputFormat", inputFormat);
            jsonObject.put("inputData", (Object)"");
            jsonObject.put("eventId", (Object)UUID.randomUUID().toString().replace("-", ""));
            return jsonObject;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public void setOnSelfServiceConfirmListener(OnSelfServiceConfirmListener onSelfServiceConfirmListener) {
        this.onSelfServiceConfirmListener = onSelfServiceConfirmListener;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (this.selfServiceDialog != null && this.selfServiceDialog.isShowing()) {
            this.selfServiceDialog.dismiss();
        }
    }

    public static interface OnSelfServiceConfirmListener {
        public void onSelected(Message var1);
    }
}

