/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import java.util.concurrent.atomic.AtomicBoolean;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.err.FaqErrorFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;

public class SupportHelper
extends FaqEventListenerWrapper {
    private final Context context;
    private final FragmentManager childFragmentManager;
    private final Bundle bundle;
    private final AtomicBoolean isSupportStarted = new AtomicBoolean();
    private int supportMode;

    public SupportHelper(Context context, FragmentManager childFragmentManager, Bundle bundle) {
        this.context = context;
        this.childFragmentManager = childFragmentManager;
        this.bundle = bundle;
    }

    public void start() {
        if (!this.isSupportStarted.get()) {
            this.supportMode = this.bundle.getInt("support_mode", 0);
            switch (this.supportMode) {
                case 7: {
                    this.onIntentToCustomerService(this.bundle, false);
                    break;
                }
                case 3: {
                    this.onIntentToQuestionList(this.bundle, false);
                    break;
                }
                case 4: {
                    this.onIntentToQuestionContent(this.bundle, false);
                    break;
                }
                case 6: {
                    this.onIntentToFillForm(this.bundle, false);
                    break;
                }
                case 8: {
                    this.onIntentToErrorEntrance();
                    break;
                }
                default: {
                    this.onIntentToSectionRoot(this.bundle, false);
                }
            }
            this.isSupportStarted.set(true);
        }
    }

    private void onIntentToErrorEntrance() {
        FaqErrorFragment faqErrorFragment = FaqErrorFragment.newInstance(this.bundle);
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), faqErrorFragment, null, null, false, false);
    }

    public void onIntentToSectionRoot(Bundle bundle, boolean isAddToBackStack) {
        String backStackName = null;
        FaqHomeFragment faqFragment = FaqHomeFragment.newInstance(bundle);
        if (isAddToBackStack) {
            backStackName = faqFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), faqFragment, null, backStackName, false, false);
    }

    @Override
    public void onIntentToQuestionList(Bundle bundle, boolean isAddToBackStack) {
        FaqListFragment fraQuestionList = FaqListFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = fraQuestionList.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraQuestionList, "", backStackName, false, false);
    }

    @Override
    public void onIntentToQuestionContent(Bundle bundle, boolean isAddToBackStack) {
        FaqContentFragment fraQuestionContent = FaqContentFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = fraQuestionContent.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), fraQuestionContent, "", backStackName, true, false);
    }

    @Override
    public void onIntentToSearch(Bundle bundle) {
        int fragmentContainerId = ResResolver.getViewId("aihelp_support_fragment_container");
        FaqSearchFragment fraSearchFaq = FaqSearchFragment.newInstance(bundle);
        FragmentHelper.startFragment(this.childFragmentManager, fragmentContainerId, fraSearchFaq, "tag_faq_search", fraSearchFaq.getClass().getName(), false, false);
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        FaqSearchFragment searchFragment = (FaqSearchFragment)this.childFragmentManager.findFragmentByTag("tag_faq_search");
        if (searchFragment != null) {
            searchFragment.onQuery(String.valueOf(s).trim());
        }
    }

    @Override
    public void onIntentToCustomerService(Bundle bundle, boolean isAddToBackStack) {
        CustomerServiceFragment customerServiceFragment = CustomerServiceFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = customerServiceFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), customerServiceFragment, null, backStackName, false, false);
    }

    @Override
    public void onIntentToFillForm(Bundle bundle, boolean isAddToBackStack) {
        IntentUrlFragment formFragment = IntentUrlFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = formFragment.getClass().getName();
        }
        FragmentHelper.startFragment(this.childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), formFragment, backStackName, backStackName, false, false);
    }

    private Fragment getTopMostFaqFragment() {
        return FragmentHelper.getTopMostFragment(this.childFragmentManager);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void afterTextChanged(Editable s) {
    }
}

