/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.fragment.app.Fragment;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.webkit.AIHelpWebViewClient;

public class WebViewInjector {
    private Context context;
    private Fragment fragment;

    public static WebViewInjector getInstance() {
        return new WebViewInjector();
    }

    public WebViewInjector setHostFragment(Fragment fragment) {
        this.fragment = fragment;
        return this;
    }

    public WebViewInjector setContext(Context context) {
        this.context = context;
        return this;
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    public void inject(WebView webView, AIHelpWebViewClient webViewClient) {
        if (Build.VERSION.SDK_INT >= 19) {
            webView.addJavascriptInterface((Object)this, "AIHelp");
            webViewClient.setOnPageLoadingProgressListener(new AIHelpWebViewClient.OnPageLoadingProgressListener(){

                @Override
                public void onPageStarted(WebView view, String url) {
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    String js = "setTimeout(function() {\n  var script = document.createElement('script');\n  script.innerHTML = `var imgList = document.getElementsByTagName('img');\n  for (const img of imgList) {\n    img.onclick = function() {\n      window.AIHelp.showImage(img.src)\n    }\n}`;\n  document.head.appendChild(script);\n}, 500);";
                    view.evaluateJavascript(js, null);
                }
            });
        }
    }

    @JavascriptInterface
    public void showImage(String imgUrl) {
        if (this.fragment != null) {
            PreviewActivity.startAct(this.fragment, PreviewInfo.get(imgUrl));
        } else if (this.context != null) {
            PreviewActivity.startAct(this.context, PreviewInfo.get(imgUrl));
        }
    }
}

