/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.io.Serializable;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.preview.util.PreviewHelper;
import net.aihelp.ui.preview.viewer.FilePreviewer;
import net.aihelp.ui.preview.viewer.ImagePreviewer;
import net.aihelp.ui.preview.viewer.VideoPreviewer;
import net.aihelp.utils.ResResolver;

public class PreviewActivity
extends BaseActivity {
    public static void startAct(Context context, PreviewInfo info) {
        if (context != null) {
            Intent intent = new Intent(context, PreviewActivity.class);
            intent.putExtra("preview_info", (Serializable)info);
            context.startActivity(intent);
        }
    }

    public static void startAct(Fragment fragment, PreviewInfo info) {
        if (fragment != null) {
            Intent intent = new Intent(fragment.getContext(), PreviewActivity.class);
            intent.putExtra("preview_info", (Serializable)info);
            if (info.isPicking()) {
                fragment.startActivityForResult(intent, 1002);
            } else {
                fragment.startActivity(intent);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        switch (CustomConfig.CommonSetting.screenOrientation) {
            case 1: {
                this.setRequestedOrientation(6);
                break;
            }
            case 2: {
                this.setRequestedOrientation(1);
                break;
            }
            case 3: {
                this.setRequestedOrientation(-1);
            }
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initView() {
        PreviewInfo info = (PreviewInfo)this.getIntent().getSerializableExtra("preview_info");
        boolean prepared = PreviewHelper.prepare((Activity)this, info);
        if (prepared) {
            if (info.isImageFile()) {
                ImagePreviewer.previewImage((Activity)this, info);
            } else if (info.isVideoFile()) {
                VideoPreviewer.previewVideo((Activity)this, info);
            } else {
                FilePreviewer.previewFile((Activity)this, info);
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (CustomConfig.CommonSetting.screenOrientation == 3) {
            CustomConfig.CommonSetting.isLandscape = newConfig.orientation == 2;
            this.setContentView(ResResolver.getLayoutId("aihelp_act_preview"));
            this.initView();
        }
    }

    @Override
    public int getLayoutId() {
        return ResResolver.getLayoutId("aihelp_act_preview");
    }
}

