/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.CircleProgressView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DownloadHelper;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class PreviewHelper {
    public static boolean prepare(Activity activity, PreviewInfo info) {
        if (activity == null) {
            return false;
        }
        if (info == null) {
            activity.setResult(0, activity.getIntent());
            activity.finish();
            return false;
        }
        PreviewHelper.prepareThemeApply(activity, info);
        PreviewHelper.prepareButtonUI(activity, info);
        PreviewHelper.prepareDownloadUI(activity, info);
        PreviewHelper.prepareOpenInBrowserUI(activity, info);
        return true;
    }

    private static void prepareThemeApply(Activity activity, PreviewInfo info) {
        boolean darkTheme;
        boolean bl = darkTheme = info.isMediaFile() || Styles.isNightMode((Context)activity);
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().setStatusBarColor(darkTheme ? -16777216 : -1);
            if (Build.VERSION.SDK_INT >= 23) {
                activity.getWindow().getDecorView().setSystemUiVisibility(darkTheme ? 0 : 8192);
            }
        }
        RelativeLayout rlPreviewTitle = (RelativeLayout)activity.findViewById(ResResolver.getViewId("aihelp_rl_preview_title"));
        rlPreviewTitle.setBackgroundColor(darkTheme ? -16777216 : -1);
        RelativeLayout rlPreviewContent = (RelativeLayout)activity.findViewById(ResResolver.getViewId("aihelp_rl_preview_content"));
        rlPreviewContent.setBackgroundColor(darkTheme ? -16777216 : -1);
    }

    private static void prepareButtonUI(final Activity activity, PreviewInfo info) {
        ImageView ivBack = (ImageView)activity.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back", true);
        ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.setResult(0, activity.getIntent());
                activity.finish();
            }
        });
        AIHelpButton btnConfirm = (AIHelpButton)activity.findViewById(ResResolver.getViewId("aihelp_btn_confirm"));
        btnConfirm.setVisibility(info.isPicking() ? 0 : 8);
        btnConfirm.setText(ResResolver.getString("aihelp_yes"));
        btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.setResult(-1, activity.getIntent());
                activity.finish();
            }
        });
    }

    private static void prepareDownloadUI(final Activity activity, final PreviewInfo info) {
        final CircleProgressView progressView = (CircleProgressView)activity.findViewById(ResResolver.getViewId("aihelp_progress_view"));
        final ImageView ivDownload = (ImageView)activity.findViewById(ResResolver.getViewId("aihelp_iv_download"));
        boolean hideIcon = RegexDefinition.isLocalMediaFile(info.getFilePath()) || info.isPicking() || !info.isMediaFile();
        ivDownload.setVisibility(hideIcon ? 8 : 0);
        ivDownload.setBackground(Styles.getDrawable(Color.parseColor((String)"#3F3F3F"), 999));
        Styles.reRenderImageView(ivDownload, "aihelp_svg_ic_download", -1, true);
        ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork((Context)activity)) {
                    ivDownload.setEnabled(false);
                    DownloadHelper.save((Context)activity, info.getFilePath(), new DownloadHelper.OnDownloadProgressChangedListener(){

                        @Override
                        public void onProgressChanged(int progress) {
                            ivDownload.setEnabled(progress == 100);
                            if (info.isVideoFile()) {
                                if (progress < 100) {
                                    progressView.setVisibility(0);
                                    progressView.setCurrentStep(progress);
                                } else {
                                    progressView.setVisibility(8);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static void prepareOpenInBrowserUI(final Activity activity, final PreviewInfo info) {
        AIHelpButton btnOpen = (AIHelpButton)activity.findViewById(ResResolver.getViewId("aihelp_btn_open"));
        btnOpen.setText(ResResolver.getString("aihelp_open_browser"));
        boolean hideIcon = RegexDefinition.isLocalFile(info.getFilePath()) || info.isPicking();
        btnOpen.setVisibility(hideIcon ? 8 : 0);
        btnOpen.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppInfoUtil.openWithBrowser((Context)activity, info.getFilePath());
            }
        });
    }
}

