/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.view.View;
import android.widget.ImageView;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.preview.viewer.BasePreviewer;
import net.aihelp.utils.ResResolver;

public class ImagePreviewer
extends BasePreviewer {
    public static void previewImage(final Activity activity, PreviewInfo info) {
        if (activity == null || info == null || ImagePreviewer.isFileSizeExceeded(activity, info)) {
            return;
        }
        PhotoView imageView = (PhotoView)activity.findViewById(ResResolver.getViewId("aihelp_image_view"));
        imageView.setVisibility(0);
        if (CustomConfig.CommonSetting.isLandscape) {
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        } else {
            imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        if (!info.isPicking()) {
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    activity.setResult(0, activity.getIntent());
                    activity.finish();
                }
            });
        }
        Glide.with(activity).load(info.getFilePath()).into((ImageView)imageView);
    }
}

